/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.sampler;

import net.imagej.sampler.PositionIterator;
import net.imagej.sampler.SamplingDefinition;

class DensePositionIterator
implements PositionIterator {
    private final int[] maxIndexes;
    private final int[] indexes;
    private final long[] currPos;

    DensePositionIterator(SamplingDefinition def) {
        this.maxIndexes = this.calcMaxes(def);
        this.currPos = new long[this.maxIndexes.length];
        for (int i = 0; i < this.currPos.length; ++i) {
            this.currPos[i] = 0L;
        }
        this.indexes = new int[this.maxIndexes.length];
        this.indexes[0] = -1;
    }

    @Override
    public boolean hasNext() {
        for (int i = 0; i < this.currPos.length; ++i) {
            if (this.indexes[i] >= this.maxIndexes[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public long[] next() {
        for (int i = 0; i < this.indexes.length; ++i) {
            int nextPos = this.indexes[i] + 1;
            if (nextPos <= this.maxIndexes[i]) {
                this.indexes[i] = nextPos;
                this.currPos[i] = nextPos;
                return this.currPos;
            }
            this.indexes[i] = 0;
            this.currPos[i] = 0L;
        }
        throw new IllegalArgumentException("Can't position iterator beyond end");
    }

    private int[] calcMaxes(SamplingDefinition def) {
        long[] dims = def.getOutputDims();
        int[] mx = new int[dims.length];
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Can only iterate <= 2 gig per dimension");
            }
            mx[i] = (int)(dims[i] - 1L);
        }
        return mx;
    }
}

