/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.sampler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.imagej.Data;
import net.imagej.axis.Axes;
import net.imagej.axis.Axis;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.display.ImageDisplay;
import net.imagej.sampler.AxisSubrange;
import net.imagej.space.SpaceUtils;

public class SamplingDefinition {
    private final ImageDisplay display;
    private final Map<AxisType, AxisSubrange> axisSubranges;
    private String err;

    private SamplingDefinition(ImageDisplay display) {
        this.display = display;
        this.axisSubranges = new HashMap<AxisType, AxisSubrange>();
        this.err = null;
    }

    public ImageDisplay getDisplay() {
        return this.display;
    }

    public String getError() {
        return this.err;
    }

    public AxisType[] getInputAxes() {
        return SpaceUtils.getAxisTypes(this.display);
    }

    public CalibratedAxis[] getInputCalibratedAxes() {
        Axis[] calibratedAxes = new CalibratedAxis[this.display.numDimensions()];
        this.display.axes(calibratedAxes);
        return calibratedAxes;
    }

    public List<List<Long>> getInputRanges() {
        ArrayList<List<Long>> axesDefs = new ArrayList<List<Long>>();
        for (int i = 0; i < this.display.numDimensions(); ++i) {
            AxisType axisType = ((CalibratedAxis)this.display.axis(i)).type();
            AxisSubrange subrange = this.axisSubranges.get(axisType);
            List<Long> axisValues = subrange.getIndices();
            axesDefs.add(axisValues);
        }
        return Collections.unmodifiableList(axesDefs);
    }

    public AxisType[] getOutputAxes() {
        AxisType[] inputAxes = this.getInputAxes();
        List<List<Long>> inputRanges = this.getInputRanges();
        int dimCount = 0;
        for (int i = 0; i < inputRanges.size(); ++i) {
            if (inputRanges.get(i).size() <= 1) continue;
            ++dimCount;
        }
        AxisType[] outputAxes = new AxisType[dimCount];
        int d = 0;
        for (int i = 0; i < inputRanges.size(); ++i) {
            if (inputRanges.get(i).size() <= 1) continue;
            outputAxes[d++] = inputAxes[i];
        }
        return outputAxes;
    }

    public CalibratedAxis[] getOutputCalibratedAxes() {
        CalibratedAxis[] inputAxes = this.getInputCalibratedAxes();
        List<List<Long>> inputRanges = this.getInputRanges();
        int dimCount = 0;
        for (int i = 0; i < inputRanges.size(); ++i) {
            if (inputRanges.get(i).size() <= 1) continue;
            ++dimCount;
        }
        CalibratedAxis[] outputAxes = new CalibratedAxis[dimCount];
        int d = 0;
        for (int i = 0; i < inputRanges.size(); ++i) {
            if (inputRanges.get(i).size() <= 1) continue;
            outputAxes[d++] = inputAxes[i].copy();
        }
        return outputAxes;
    }

    public long[] getOutputDims() {
        List<List<Long>> inputRanges = this.getInputRanges();
        int dimCount = 0;
        for (int i = 0; i < inputRanges.size(); ++i) {
            if (inputRanges.get(i).size() <= 1) continue;
            ++dimCount;
        }
        long[] outputDims = new long[dimCount];
        int d = 0;
        for (int i = 0; i < inputRanges.size(); ++i) {
            int dimSize = inputRanges.get(i).size();
            if (dimSize <= 1) continue;
            outputDims[d++] = dimSize;
        }
        return outputDims;
    }

    @Deprecated
    public double[] getOutputCalibration(AxisType[] outputAxes) {
        double[] cal = new double[outputAxes.length];
        int a = 0;
        for (int i = 0; i < outputAxes.length; ++i) {
            int axisIndex = this.display.dimensionIndex(outputAxes[i]);
            if (axisIndex < 0) continue;
            cal[a++] = ((CalibratedAxis)this.display.axis(axisIndex)).averageScale(0.0, 1.0);
        }
        return cal;
    }

    public boolean constrain(AxisType axis, AxisSubrange subrange) {
        if (subrange.getError() != null) {
            this.err = subrange.getError();
            return false;
        }
        Data data = this.display.getActiveView().getData();
        int axisIndex = data.dimensionIndex(axis);
        if (axisIndex < 0) {
            this.err = "Undefined axis " + axis + " for display " + this.display.getName();
            return false;
        }
        List<Long> indices = subrange.getIndices();
        double dimension = data.realMax(axisIndex) - data.realMin(axisIndex);
        if ((double)indices.get(0).longValue() > dimension) {
            this.err = "Axis range fully beyond dimensions of display " + this.display.getName() + " for axis " + axis;
            return false;
        }
        if ((double)indices.get(indices.size() - 1).longValue() > dimension) {
            this.err = "Axis range partially beyond dimensions of display " + this.display.getName() + " for axis " + axis;
            return false;
        }
        this.axisSubranges.put(axis, subrange);
        return true;
    }

    public static SamplingDefinition sampleUVPlane(ImageDisplay display, AxisType uAxis, AxisType vAxis) {
        SamplingDefinition definition = new SamplingDefinition(display);
        Data data = display.getActiveView().getData();
        for (int i = 0; i < data.numDimensions(); ++i) {
            AxisType axisType = ((CalibratedAxis)data.axis(i)).type();
            if (axisType == uAxis || axisType == vAxis) {
                int axisIndex = display.dimensionIndex(axisType);
                long size = display.dimension(axisIndex);
                AxisSubrange subrange = new AxisSubrange(0L, size - 1L);
                definition.constrain(axisType, subrange);
                continue;
            }
            long pos = display.getLongPosition(axisType);
            AxisSubrange subrange = new AxisSubrange(pos);
            definition.constrain(axisType, subrange);
        }
        return definition;
    }

    public static SamplingDefinition sampleXYPlane(ImageDisplay display) {
        return SamplingDefinition.sampleUVPlane(display, Axes.X, Axes.Y);
    }

    public static SamplingDefinition sampleCompositeUVPlane(ImageDisplay display, AxisType uAxis, AxisType vAxis) {
        if (uAxis == Axes.CHANNEL || vAxis == Axes.CHANNEL) {
            throw new IllegalArgumentException("UV composite plane - cannot specify channels as one of the axes");
        }
        SamplingDefinition definition = new SamplingDefinition(display);
        Data data = display.getActiveView().getData();
        for (int i = 0; i < data.numDimensions(); ++i) {
            AxisType axisType = ((CalibratedAxis)data.axis(i)).type();
            if (axisType == uAxis || axisType == vAxis || axisType == Axes.CHANNEL) {
                int axisIndex = display.dimensionIndex(axisType);
                long size = display.dimension(axisIndex);
                AxisSubrange subrange = new AxisSubrange(0L, size - 1L);
                definition.constrain(axisType, subrange);
                continue;
            }
            long pos = display.getLongPosition(axisType);
            AxisSubrange subrange = new AxisSubrange(pos);
            definition.constrain(axisType, subrange);
        }
        return definition;
    }

    public static SamplingDefinition sampleCompositeXYPlane(ImageDisplay display) {
        return SamplingDefinition.sampleCompositeUVPlane(display, Axes.X, Axes.Y);
    }

    public static SamplingDefinition sampleAllPlanes(ImageDisplay display) {
        SamplingDefinition definition = new SamplingDefinition(display);
        for (int i = 0; i < display.numDimensions(); ++i) {
            AxisType axisType = ((CalibratedAxis)display.axis(i)).type();
            long size = display.dimension(i);
            AxisSubrange subrange = new AxisSubrange(0L, size - 1L);
            definition.constrain(axisType, subrange);
        }
        return definition;
    }
}

