/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.types;

import java.math.BigDecimal;
import net.imagej.types.BigComplex;
import net.imagej.types.DataType;
import net.imglib2.type.numeric.integer.LongType;
import org.scijava.AbstractContextual;
import org.scijava.plugin.Plugin;

@Plugin(type=DataType.class)
public class DataType64BitSignedInteger
extends AbstractContextual
implements DataType<LongType> {
    private final LongType type = new LongType();

    @Override
    public LongType getType() {
        return this.type;
    }

    @Override
    public String shortName() {
        return "64-bit int";
    }

    @Override
    public String longName() {
        return "64-bit signed integer";
    }

    @Override
    public String description() {
        return "An integer data type ranging between -9223372036854775808 and 9223372036854775807";
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isFloat() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public void lowerBound(LongType dest) {
        dest.set(Long.MIN_VALUE);
    }

    @Override
    public void upperBound(LongType dest) {
        dest.set(Long.MAX_VALUE);
    }

    @Override
    public int bitCount() {
        return 64;
    }

    @Override
    public LongType createVariable() {
        return new LongType();
    }

    @Override
    public void cast(LongType val, BigComplex dest) {
        dest.setReal(val.get());
        dest.setImag(BigDecimal.ZERO);
    }

    @Override
    public void cast(BigComplex val, LongType dest) {
        this.setLong(dest, val.getReal().longValue());
    }

    @Override
    public boolean hasDoubleRepresentation() {
        return false;
    }

    @Override
    public boolean hasLongRepresentation() {
        return true;
    }

    @Override
    public double asDouble(LongType val) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong(LongType val) {
        return val.get();
    }

    @Override
    public void setDouble(LongType val, double v) {
        this.setLong(val, (long)v);
    }

    @Override
    public void setLong(LongType val, long v) {
        val.set(v);
    }
}

