/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.viewer.image;

import net.imagej.Data;
import net.imagej.Dataset;
import net.imagej.Position;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imagej.display.DataView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.event.DelayedPositionEvent;
import net.imagej.display.event.PanZoomEvent;
import net.imagej.event.DatasetRestructuredEvent;
import net.imagej.event.DatasetUpdatedEvent;
import net.imagej.ui.viewer.image.ImageDisplayViewer;
import net.imglib2.img.Img;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.type.numeric.RealType;
import org.scijava.display.Display;
import org.scijava.display.event.DisplayUpdatedEvent;
import org.scijava.display.event.window.WinActivatedEvent;
import org.scijava.event.EventHandler;
import org.scijava.options.OptionsService;
import org.scijava.plugin.Parameter;
import org.scijava.tool.ToolService;
import org.scijava.ui.viewer.AbstractDisplayViewer;
import org.scijava.ui.viewer.DisplayPanel;
import org.scijava.ui.viewer.DisplayWindow;
import org.scijava.util.UnitUtils;

public abstract class AbstractImageDisplayViewer
extends AbstractDisplayViewer<DataView>
implements ImageDisplayViewer {
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private ToolService toolService;
    @Parameter
    private OptionsService optionsService;
    private ImageDisplay display;

    @Override
    public ImageDisplay getDisplay() {
        return this.display;
    }

    public boolean canView(Display<?> d) {
        return d instanceof ImageDisplay;
    }

    public void view(DisplayWindow w, Display<?> d) {
        super.view(w, d);
        this.display = (ImageDisplay)d;
    }

    protected Dataset getDataset(DataView view) {
        Data data = view.getData();
        return data instanceof Dataset ? (Dataset)data : null;
    }

    protected void updateLabel() {
        ImageDisplay d = this.getDisplay();
        if (d == null || d.getActiveView() == null) {
            return;
        }
        DisplayPanel p = this.getPanel();
        if (p != null) {
            p.setLabel(this.makeLabel());
        }
    }

    protected ZoomScaleOption getZoomScaleOption() {
        return ZoomScaleOption.OPTIONS_PERCENT_SCALE;
    }

    protected void updateTitle() {
        String name;
        Img<RealType<?>> img;
        String trailer = "";
        Dataset ds = this.imageDisplayService.getActiveDataset(this.display);
        if (ds != null && AbstractCellImg.class.isAssignableFrom((img = ds.getImgPlus().getImg()).getClass())) {
            trailer = " (V)";
        }
        if ((name = this.getDisplay().getName()) == null) {
            name = "";
        }
        this.getWindow().setTitle(name + trailer);
    }

    private String makeLabel() {
        DataView view = this.getDisplay().getActiveView();
        Dataset dataset = this.getDataset(view);
        int xIndex = dataset.dimensionIndex(Axes.X);
        int yIndex = dataset.dimensionIndex(Axes.Y);
        Position pos = view.getPlanePosition();
        StringBuilder sb = new StringBuilder();
        int p = -1;
        for (int i = 0; i < dataset.numDimensions(); ++i) {
            long dim = dataset.dimension(i);
            AxisType axis = ((CalibratedAxis)dataset.axis(i)).type();
            if (axis.isXY()) continue;
            ++p;
            if (dim == 1L) continue;
            sb.append(axis);
            sb.append(": ");
            sb.append(pos.getLongPosition(p) + 1L);
            sb.append("/");
            sb.append(dim);
            sb.append("; ");
        }
        sb.append(dataset.dimension(xIndex));
        sb.append("x");
        sb.append(dataset.dimension(yIndex));
        sb.append("; ");
        sb.append(dataset.getTypeLabelLong());
        sb.append("; ");
        sb.append(this.byteInfoString(dataset));
        sb.append("; ");
        double zoomFactor = this.getDisplay().getCanvas().getZoomFactor();
        if (zoomFactor != 1.0) {
            sb.append("(");
            sb.append(this.getScaleConverter().getString(zoomFactor));
            sb.append(")");
        }
        return sb.toString();
    }

    private String byteInfoString(Dataset ds) {
        double byteCount = ds.getBytesOfInfo();
        return UnitUtils.getAbbreviatedByteLabel((double)byteCount);
    }

    private ScaleConverter getScaleConverter() {
        if (this.getZoomScaleOption().equals((Object)ZoomScaleOption.OPTIONS_FRACTIONAL_SCALE)) {
            return new FractionalScaleConverter();
        }
        return new PercentScaleConverter();
    }

    private boolean isMyDataset(Dataset ds) {
        if (ds == null) {
            return false;
        }
        ImageDisplay disp = this.getDisplay();
        return this.imageDisplayService.getActiveDataset(disp) == ds;
    }

    @EventHandler
    protected void onEvent(WinActivatedEvent event) {
        if (event.getDisplay() != this.getDisplay()) {
            return;
        }
        ImageDisplay d = this.getDisplay();
        if (d == null) {
            return;
        }
        d.getCanvas().setCursor(this.toolService.getActiveTool().getCursor());
    }

    @EventHandler
    protected void onEvent(PanZoomEvent event) {
        if (event.getDisplay() != this.getDisplay()) {
            return;
        }
        this.updateLabel();
    }

    @EventHandler
    protected void onEvent(DatasetRestructuredEvent event) {
        if (this.isMyDataset(event.getObject())) {
            this.updateLabel();
        }
    }

    @EventHandler
    protected void onEvent(DelayedPositionEvent event) {
        if (event.getDisplay() != this.getDisplay()) {
            return;
        }
        this.updateLabel();
    }

    @EventHandler
    protected void onEvent(DatasetUpdatedEvent event) {
        if (!this.isMyDataset(event.getObject())) {
            return;
        }
        this.updateLabel();
        this.updateTitle();
    }

    @EventHandler
    protected void onEvent(DisplayUpdatedEvent event) {
        if (event.getDisplay() != this.getDisplay()) {
            return;
        }
        this.updateLabel();
        this.updateTitle();
    }

    private class FractionalScale {
        private int numer = 0;
        private int denom = 0;

        FractionalScale(double realScale) {
            if (realScale >= 1.0) {
                double floor = Math.floor(realScale);
                if (realScale - floor < 1.0E-4) {
                    this.numer = (int)floor;
                    this.denom = 1;
                }
            } else {
                double recip = 1.0 / realScale;
                double floor = Math.floor(recip);
                if (recip - floor < 1.0E-4) {
                    this.numer = 1;
                    this.denom = (int)floor;
                }
            }
            if (this.denom == 0) {
                this.lookForBestFraction(realScale);
            }
        }

        int getNumer() {
            return this.numer;
        }

        int getDenom() {
            return this.denom;
        }

        private void lookForBestFraction(double scale) {
            int quickRange = 32;
            for (int n = 1; n <= 32; ++n) {
                for (int d = 1; d <= 32; ++d) {
                    double frac = 1.0 * (double)n / (double)d;
                    if (!(Math.abs(scale - frac) < 1.0E-4)) continue;
                    this.numer = n;
                    this.denom = d;
                    return;
                }
            }
        }
    }

    private class FractionalScaleConverter
    implements ScaleConverter {
        private FractionalScaleConverter() {
        }

        @Override
        public String getString(double realScale) {
            FractionalScale scale = new FractionalScale(realScale);
            if (scale.getDenom() == 0) {
                if (realScale >= 1.0) {
                    return String.format("%.2fX", realScale);
                }
                return String.format("1/%.2fX", 1.0 / realScale);
            }
            if (scale.getDenom() == 1) {
                return String.format("%dX", scale.getNumer());
            }
            return String.format("%d/%dX", scale.getNumer(), scale.getDenom());
        }
    }

    private class PercentScaleConverter
    implements ScaleConverter {
        private PercentScaleConverter() {
        }

        @Override
        public String getString(double realScale) {
            return String.format("%.2f%%", realScale * 100.0);
        }
    }

    private static interface ScaleConverter {
        public String getString(double var1);
    }

    protected static enum ZoomScaleOption {
        OPTIONS_PERCENT_SCALE,
        OPTIONS_FRACTIONAL_SCALE;

    }
}

