/*
 * Decompiled with CFR 0.152.
 */
package org.drjekyll.fontchooser.panes;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.TreeSet;
import javax.swing.JTextField;
import org.drjekyll.fontchooser.panes.FamilyPane;

public class SearchListener
extends KeyAdapter {
    private final Collection<String> fontFamilyNames = new TreeSet<String>();
    private final FamilyPane familyPane;

    @Override
    public void keyTyped(KeyEvent e) {
        JTextField searchField = (JTextField)e.getSource();
        String searchString = searchField.getText().toLowerCase(Locale.ENGLISH);
        Optional<String> first = this.fontFamilyNames.stream().filter(family -> family.toLowerCase(Locale.ENGLISH).contains(searchString)).findFirst();
        first.ifPresent(this.familyPane::setSelectedFamily);
    }

    public void addFamilyName(String name) {
        this.fontFamilyNames.add(name);
    }

    public SearchListener(FamilyPane familyPane) {
        this.familyPane = familyPane;
    }
}

