/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Frame;
import java.awt.Rectangle;
import java.io.File;
import java.util.Properties;
import mmorpho.Constants;
import mmorpho.MorphoProcessor;
import mmorpho.StructureElement;

public class GrayMorphology_
implements PlugInFilter,
Constants {
    ImagePlus imp;
    public String kernelText = " 0 0 0 0 0\n 0 0 255 0 0\n 0 255 255 255 0\n 0 0 255 0 0\n 0 0 0 0 0\n";
    private static final String R = "SE_r";
    private static final String SHOW = "show_SE";
    private static final String SETYPE = "SE_type";
    private static final String OPER = "MOper";
    boolean canceled = true;
    private static final int[] offset = OFFSET0;
    public StructureElement se;
    public StructureElement minus_se;
    public StructureElement plus_se;
    public StructureElement down_se;
    public StructureElement up_se;
    MorphoProcessor mp;
    ImageWindow win;
    private static float radius = (float)Prefs.getDouble((String)"SE_r", (double)1.0);
    private static int options = Prefs.getInt((String)"SE_type", (int)0);
    private static boolean showoptions = Prefs.getBoolean((String)"show_SE", (boolean)false);
    private static int morphoptions = Prefs.getInt((String)"MOper", (int)0);
    public static final String[] strelitems = new String[]{"circle", "diamond", "square", "hor line", "ver line", "2p h", "2p v", "free form"};
    public static final int[] constitems = new int[]{0, 1, 7, 4, 3, 6, 5, -1};
    public static final String[] morphitems = new String[]{"erode", "dilate", "open", "close", "fast erode", "fast dilate", "fast open", "fast close"};
    public static final int ERODE = 0;
    public static final int DILATE = 1;
    public static final int OPEN = 2;
    public static final int CLOSE = 3;
    public static final int FERODE = 4;
    public static final int FDILATE = 5;
    public static final int FOPEN = 6;
    public static final int FCLOSE = 7;
    private Roi roi;
    boolean isLineRoi;
    int slice = 0;
    private boolean seshown = false;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        IJ.register(GrayMorphology_.class);
        if (arg.equals("about")) {
            this.showAbout();
            return 4096;
        }
        if (imp != null) {
            this.win = imp.getWindow();
            if (this.win != null) {
                this.win.running = true;
            }
            this.roi = imp.getRoi();
            boolean bl = this.isLineRoi = this.roi != null && this.roi.getType() == 5;
        }
        if (IJ.versionLessThan((String)"1.35") || !this.showDialog(imp)) {
            return 4096;
        }
        return 33;
    }

    boolean showDialog(ImagePlus imp) {
        if (imp == null) {
            return true;
        }
        GenericDialog gd = new GenericDialog("Parameters");
        gd.addMessage("This plugin performs morphology operators on graylevel images\n");
        gd.addNumericField("Radius of the structure element (pixels):", (double)radius, 1);
        gd.addChoice("Type of structure element", strelitems, strelitems[options]);
        gd.addCheckbox("Show mask", showoptions);
        gd.addChoice("Operator", morphitems, morphitems[morphoptions]);
        gd.showDialog();
        radius = (float)gd.getNextNumber();
        options = gd.getNextChoiceIndex();
        showoptions = gd.getNextBoolean();
        morphoptions = gd.getNextChoiceIndex();
        if (gd.wasCanceled()) {
            return false;
        }
        if (!this.validate(radius, 2)) {
            IJ.showMessage((String)"Invalid Numbers!\nEnter floats 0.5 or 1");
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            File f = new File(args[0]);
            if (!f.exists() || !f.isDirectory()) {
                throw new IllegalArgumentException();
            }
            System.setProperty("plugins.dir", args[0]);
            new ImageJ();
        }
        catch (Exception ex) {
            IJ.log((String)"plugins.dir misspecified\n");
            ex.printStackTrace();
        }
    }

    public void showStrEl(StructureElement strel, String Title) {
        int wh = strel.getWidth();
        int hh = strel.getHeight();
        ImageProcessor fp = new FloatProcessor(wh, hh, strel.getMask()).convertToByte(false);
        new ImagePlus(Title, fp).show();
        this.seshown = true;
    }

    public int[] Abs(int[] arr) {
        int[] warr = new int[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            warr[i] = Math.abs(arr[i]);
        }
        return warr;
    }

    public ByteProcessor getMask(ByteProcessor ip, Rectangle r) {
        int width = ip.getWidth();
        byte[] pixels = (byte[])ip.getPixels();
        int xloc = (int)r.getX();
        int yloc = (int)r.getY();
        int w = (int)r.getWidth();
        int h = (int)r.getHeight();
        byte[] mask = new byte[w * h];
        for (int cnt = 0; cnt < mask.length; ++cnt) {
            int index = xloc + cnt % w + cnt / w * width + yloc * width;
            mask[cnt] = (byte)(pixels[index] & 0xFF);
        }
        return new ByteProcessor(w, h, mask, ip.getColorModel());
    }

    public void run(ImageProcessor ip) {
        int shift = 1;
        if (IJ.escapePressed()) {
            IJ.beep();
            return;
        }
        int eltype = constitems[options];
        if (eltype == -1) {
            this.se = this.inputSE();
        } else {
            shift = 1;
            this.se = new StructureElement(eltype, shift, radius, offset);
        }
        if (this.se != null) {
            Rectangle r;
            this.mp = new MorphoProcessor(this.se);
            if (showoptions && !this.seshown) {
                this.minus_se = this.mp.getSE(-1);
                this.plus_se = this.mp.getSE(1);
                this.showStrEl(this.se, "SE r=" + radius);
                this.showStrEl(this.minus_se, "minus SE r=" + radius);
                this.showStrEl(this.plus_se, "plus SE r=" + radius);
            }
            ++this.slice;
            if (this.slice > 1) {
                IJ.showStatus((String)(this.imp.getTitle() + " : " + this.slice + "/" + this.imp.getStackSize()));
            }
            if ((r = ip.getRoi()) == null) {
                this.doOptions(ip, this.mp, morphoptions);
            } else if (!this.isLineRoi) {
                ByteProcessor ipmask = this.getMask((ByteProcessor)ip, r);
                this.doOptions((ImageProcessor)ipmask, this.mp, morphoptions);
                ip.insert((ImageProcessor)ipmask, r.x, r.y);
            }
            if (this.slice == this.imp.getImageStackSize()) {
                this.imp.updateAndDraw();
            }
        }
    }

    private void doOptions(ImageProcessor ip, MorphoProcessor mp, int morphoptions) {
        switch (morphoptions) {
            case 0: {
                mp.erode(ip);
                break;
            }
            case 1: {
                mp.dilate(ip);
                break;
            }
            case 2: {
                mp.open(ip);
                break;
            }
            case 3: {
                mp.close(ip);
                break;
            }
            case 4: {
                if (this.se.getType() == 4 || this.se.getType() == 3) {
                    mp.LineErode(ip);
                    break;
                }
                mp.fastErode(ip);
                break;
            }
            case 5: {
                if (this.se.getType() == 4 || this.se.getType() == 3) {
                    mp.LineDilate(ip);
                    break;
                }
                mp.fastDilate(ip);
                break;
            }
            case 6: {
                if (this.se.getType() == 4 || this.se.getType() == 3) {
                    mp.LineErode(ip);
                    mp.LineDilate(ip);
                    break;
                }
                mp.fopen(ip);
                break;
            }
            case 7: {
                if (this.se.getType() == 4 || this.se.getType() == 3) {
                    mp.LineDilate(ip);
                    mp.LineErode(ip);
                    break;
                }
                mp.fclose(ip);
            }
        }
    }

    private StructureElement inputSE() {
        GenericDialog gd = new GenericDialog("Input Mask", (Frame)IJ.getInstance());
        gd.addTextAreas(this.kernelText, null, 10, 30);
        gd.showDialog();
        if (gd.wasCanceled()) {
            this.canceled = true;
            return null;
        }
        this.kernelText = gd.getNextText();
        return new StructureElement(this.kernelText);
    }

    private boolean validate(float var, int k) {
        float a = (float)k * var;
        int b = (int)((float)k * var);
        return a - (float)b == 0.0f || var < 0.0f;
    }

    public static void savePreferences(Properties prefs) {
        prefs.put(R, Double.toString(radius));
        prefs.put(SHOW, Boolean.toString(showoptions));
        prefs.put(SETYPE, Integer.toString(options));
        prefs.put(OPER, Integer.toString(morphoptions));
    }

    public void Log(int[][] a) {
        String aStr = "";
        int h = a.length;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < a[i].length; ++j) {
                aStr = aStr + a[i][j] + "  ";
            }
            IJ.log((String)aStr);
            aStr = "";
        }
    }

    void showAbout() {
        IJ.showMessage((String)"Gray Morphology version  2.3", (String)"This plugin performs the basic morphologic operations on grayscale images \n  erosion, dilation, opening and closing with several types of structuring elements.\nIt is build upon the StructureElement class. \nThe develpoment of this alogorithm was inspired by the book of Jean Serra \n\"Image Analysis and Mathematical Morphology\"");
    }
}

