/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.hdf5;

import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import sc.fiji.hdf5.HDF5ImageJ;

public class HDF5_Simple_Reader
implements PlugIn {
    public void run(String arg) {
        OpenDialog od = new OpenDialog("Load HDF5", "", "");
        String filename = od.getPath();
        GenericDialog gd = new GenericDialog("Load HDF5");
        gd.addMessage("Comma-separated or space-separated list of dataset names.");
        String commaSeparatedDsetNames = Prefs.get((String)"hdf5readervibez.dsetnames", (String)"");
        gd.addStringField("datasetnames", commaSeparatedDsetNames, 128);
        int nFrames = (int)Prefs.get((String)"hdf5readervibez.nframes", (double)1.0);
        gd.addNumericField("nframes", (double)nFrames, 0);
        int nChannels = (int)Prefs.get((String)"hdf5readervibez.nchannels", (double)1.0);
        gd.addNumericField("nchannels", (double)nChannels, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String datasetnames = gd.getNextString();
        int nframes = (int)gd.getNextNumber();
        int nchannels = (int)gd.getNextNumber();
        HDF5ImageJ.loadDataSetsToHyperStack(filename, datasetnames.split(","), nframes, nchannels);
    }
}

