/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.models;

import bdv.viewer.ViewerPanel;
import net.imglib2.Interval;
import net.imglib2.realtransform.AffineTransform3D;
import sc.fiji.labkit.pixel_classification.RevampUtils;
import sc.fiji.labkit.ui.utils.BdvUtils;

public class TransformationModel {
    private final boolean isTimeSeries;
    private ViewerPanel viewerPanel;

    public TransformationModel(boolean isTimeSeries) {
        this.isTimeSeries = isTimeSeries;
    }

    public void initialize(ViewerPanel viewerPanel) {
        this.viewerPanel = viewerPanel;
    }

    public void transformToShowInterval(Interval interval, AffineTransform3D transformation) {
        if (this.viewerPanel == null) {
            return;
        }
        if (this.isTimeSeries) {
            int lastDim = interval.numDimensions() - 1;
            long meanTimePoint = (interval.min(lastDim) + interval.max(lastDim)) / 2L;
            if (this.viewerPanel != null) {
                this.viewerPanel.setTimepoint((int)meanTimePoint);
            }
            interval = RevampUtils.removeLastDimension((Interval)interval);
        }
        BdvUtils.resetView(this.viewerPanel, interval, transformation);
    }
}

