/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import java.util.Arrays;
import net.imglib2.AbstractRealLocalizable;
import net.imglib2.Localizable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.util.Localizables;

public class RealPoint
extends AbstractRealLocalizable
implements RealPositionable {
    protected RealPoint(double[] position, boolean copy) {
        super(copy ? (double[])position.clone() : position);
    }

    public RealPoint(int n) {
        super(n);
    }

    public RealPoint(double ... position) {
        this(position, true);
    }

    public RealPoint(float ... position) {
        super(position.length);
        this.setPosition(position);
    }

    public RealPoint(RealLocalizable localizable) {
        super(localizable.numDimensions());
        localizable.localize(this.position);
    }

    @Override
    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1.0;
    }

    @Override
    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1.0;
    }

    @Override
    public void move(int distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    @Override
    public void move(long distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    @Override
    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + localizable.getDoublePosition(d);
        }
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = localizable.getDoublePosition(d);
        }
    }

    @Override
    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    @Override
    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    @Override
    public void setPosition(int position, int d) {
        this.position[d] = position;
    }

    @Override
    public void setPosition(long position, int d) {
        this.position[d] = position;
    }

    @Override
    public void move(float distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    @Override
    public void move(double distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    @Override
    public void move(RealLocalizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + localizable.getDoublePosition(d);
        }
    }

    @Override
    public void move(float[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    @Override
    public void move(double[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
        }
    }

    @Override
    public void setPosition(RealLocalizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = localizable.getDoublePosition(d);
        }
    }

    @Override
    public void setPosition(float[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    @Override
    public void setPosition(double[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    @Override
    public void setPosition(float position, int d) {
        this.position[d] = position;
    }

    @Override
    public void setPosition(double position, int d) {
        this.position[d] = position;
    }

    public String toString() {
        return Localizables.toString(this);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && Localizables.equals(this, (RealPoint)obj);
    }

    public int hashCode() {
        return Arrays.hashCode(this.position);
    }

    public static RealPoint wrap(double[] position) {
        return new RealPoint(position, false);
    }
}

