/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.basictypeaccess.nio;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import net.imglib2.img.basictypeaccess.array.AbstractCharArray;
import net.imglib2.img.basictypeaccess.nio.AbstractBufferAccess;
import net.imglib2.img.basictypeaccess.volatiles.VolatileCharAccess;

public class CharBufferAccess
extends AbstractBufferAccess<CharBufferAccess, CharBuffer>
implements VolatileCharAccess {
    private static final long serialVersionUID = -7265085228179236189L;
    private static final int NUM_BYTES_PER_ENTITY = 2;

    public CharBufferAccess(CharBuffer buffer, boolean isValid) {
        super(buffer, isValid);
    }

    public CharBufferAccess(int numEntities, boolean isValid) {
        super(CharBuffer.allocate(numEntities), isValid);
    }

    public CharBufferAccess(ByteBuffer buffer, boolean isValid) {
        super(buffer.asCharBuffer(), isValid);
    }

    public CharBufferAccess(CharBuffer buffer) {
        this(buffer, true);
    }

    public CharBufferAccess(int numEntities) {
        this(numEntities, true);
    }

    public CharBufferAccess(ByteBuffer buffer) {
        this(buffer, true);
    }

    public CharBufferAccess() {
        this((CharBuffer)null, false);
    }

    @Override
    public char getValue(int index) {
        return ((CharBuffer)this.buffer).get(index);
    }

    @Override
    public void setValue(int index, char value) {
        ((CharBuffer)this.buffer).put(index, value);
    }

    @Override
    public int getNumBytesPerEntity() {
        return 2;
    }

    @Override
    public CharBufferAccess newInstance(ByteBuffer buffer, boolean isValid) {
        return CharBufferAccess.fromByteBuffer(buffer, isValid);
    }

    @Override
    public CharBufferAccess newInstance(CharBuffer buffer, boolean isValid) {
        return new CharBufferAccess(buffer, isValid);
    }

    @Override
    CharBuffer duplicateBuffer(CharBuffer buffer) {
        return buffer.duplicate();
    }

    @Override
    CharBufferAccess allocate(int numEntities, boolean isDirect, boolean isValid) {
        if (isDirect) {
            return (CharBufferAccess)super.allocate(numEntities, isDirect, isValid);
        }
        return new CharBufferAccess(numEntities, isValid);
    }

    public static CharBufferAccess fromByteBuffer(ByteBuffer buffer, boolean isValid) {
        return new CharBufferAccess(buffer, isValid);
    }

    public CharBuffer getValues(AbstractCharArray<?> array) {
        return ((CharBuffer)this.buffer).duplicate().get(array.getCurrentStorageArray());
    }

    public CharBuffer getValues(AbstractCharArray<?> array, int offset, int length) {
        return ((CharBuffer)this.buffer).duplicate().get(array.getCurrentStorageArray(), offset, length);
    }

    public CharBuffer setValues(AbstractCharArray<?> array) {
        return ((CharBuffer)this.buffer).duplicate().put(array.getCurrentStorageArray());
    }

    public CharBuffer setValues(AbstractCharArray<?> array, int offset, int length) {
        return ((CharBuffer)this.buffer).duplicate().put(array.getCurrentStorageArray(), offset, length);
    }

    public CharBuffer setValues(CharBufferAccess access) {
        return ((CharBuffer)this.buffer).duplicate().put((CharBuffer)access.getCurrentStorageArray());
    }
}

