/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.sparse;

import net.imglib2.Dimensions;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.sparse.ByteNtree;
import net.imglib2.img.sparse.CharNtree;
import net.imglib2.img.sparse.DoubleNtree;
import net.imglib2.img.sparse.FloatNtree;
import net.imglib2.img.sparse.IntNtree;
import net.imglib2.img.sparse.LongNtree;
import net.imglib2.img.sparse.NtreeAccess;
import net.imglib2.img.sparse.NtreeImg;
import net.imglib2.img.sparse.ShortNtree;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.util.Fraction;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public class NtreeImgFactory<T extends NativeType<T>>
extends NativeImgFactory<T> {
    public NtreeImgFactory(T type) {
        super(type);
    }

    @Override
    public NtreeImg<T, ?> create(long ... dimensions) {
        return this.create(dimensions, (NativeType)this.type(), ((NativeType)this.type()).getNativeTypeFactory());
    }

    @Override
    public NtreeImg<T, ?> create(Dimensions dimensions) {
        return this.create(Intervals.dimensionsAsLongArray(dimensions));
    }

    @Override
    public NtreeImg<T, ?> create(int[] dimensions) {
        return this.create(Util.int2long(dimensions));
    }

    private <A> NtreeImg<T, ?> create(long[] dimensions, T type, NativeTypeFactory<T, A> typeFactory) {
        Dimensions.verify(dimensions);
        Fraction entitiesPerPixel = type.getEntitiesPerPixel();
        if (entitiesPerPixel.getNumerator() != entitiesPerPixel.getDenominator()) {
            throw new RuntimeException("not implemented");
        }
        long[] pos = new long[dimensions.length];
        NtreeImg img = new NtreeImg(NtreeImgFactory.createNtreeAccess(typeFactory, dimensions).createInstance(pos), dimensions, entitiesPerPixel);
        img.setLinkedType(typeFactory.createLinkedType(img));
        return img;
    }

    public static <A extends NtreeAccess<?, A>> A createNtreeAccess(NativeTypeFactory<?, ? super A> typeFactory, long[] dimensions) {
        switch (typeFactory.getPrimitiveType()) {
            case BYTE: {
                return (A)new ByteNtree(dimensions, null, 0);
            }
            case CHAR: {
                return (A)new CharNtree(dimensions, null, '\u0000');
            }
            case DOUBLE: {
                return (A)new DoubleNtree(dimensions, null, 0.0);
            }
            case FLOAT: {
                return (A)new FloatNtree(dimensions, null, 0.0f);
            }
            case INT: {
                return (A)new IntNtree(dimensions, null, 0);
            }
            case LONG: {
                return (A)new LongNtree(dimensions, null, 0L);
            }
            case SHORT: {
                return (A)new ShortNtree(dimensions, null, 0);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
        if (NativeType.class.isInstance(type)) {
            return new NtreeImgFactory<NativeType>((NativeType)type);
        }
        throw new IncompatibleTypeException(this, type.getClass().getCanonicalName() + " does not implement NativeType.");
    }

    @Deprecated
    public NtreeImgFactory() {
    }

    @Override
    @Deprecated
    public NtreeImg<T, ?> create(long[] dimensions, T type) {
        this.cache(type);
        return this.create(dimensions, type, type.getNativeTypeFactory());
    }
}

