/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.iterator;

import net.imglib2.AbstractInterval;
import net.imglib2.Interval;
import net.imglib2.Iterator;
import net.imglib2.Localizable;
import net.imglib2.iterator.ZeroMinIntervalIterator;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Util;

public class IntervalIterator
extends AbstractInterval
implements Iterator,
Localizable {
    protected final long[] dimensions = new long[this.n];
    protected final long[] steps = new long[this.n];
    protected final long lastIndex;
    protected long index = -1L;

    public IntervalIterator(long[] dimensions) {
        super(dimensions);
        long dimm;
        int m = this.n - 1;
        this.steps[0] = 1L;
        long k = 1L;
        int d = 0;
        while (d < m) {
            long dimd;
            this.dimensions[d] = dimd = dimensions[d];
            this.steps[++d] = k *= dimd;
        }
        this.dimensions[m] = dimm = dimensions[m];
        this.lastIndex = k * dimm - 1L;
    }

    public IntervalIterator(int[] dimensions) {
        this(Util.int2long(dimensions));
    }

    public IntervalIterator(long[] min, long[] max) {
        super(min, max);
        long sizem;
        int m = this.n - 1;
        this.steps[0] = 1L;
        long k = 1L;
        int d = 0;
        while (d < m) {
            long s;
            this.dimensions[d] = s = max[d] - min[d] + 1L;
            this.steps[++d] = k *= s;
        }
        this.dimensions[m] = sizem = max[m] - min[m] + 1L;
        this.lastIndex = k * sizem - 1L;
    }

    public IntervalIterator(int[] min, int[] max) {
        this(Util.int2long(min), Util.int2long(max));
    }

    public IntervalIterator(Interval interval) {
        super(interval);
        long dimm;
        int m = this.n - 1;
        this.steps[0] = 1L;
        long k = 1L;
        int d = 0;
        while (d < m) {
            long dimd;
            this.dimensions[d] = dimd = interval.dimension(d);
            this.steps[++d] = k *= dimd;
        }
        this.dimensions[m] = dimm = interval.dimension(m);
        this.lastIndex = k * dimm - 1L;
    }

    public static IntervalIterator create(Interval interval) {
        int n = interval.numDimensions();
        for (int d = 0; d < n; ++d) {
            if (interval.min(d) == 0L) continue;
            return new IntervalIterator(interval);
        }
        return new ZeroMinIntervalIterator(interval);
    }

    @Override
    public void jumpFwd(long i) {
        this.index += i;
    }

    @Override
    public void fwd() {
        ++this.index;
    }

    @Override
    public void reset() {
        this.index = -1L;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.lastIndex;
    }

    public long getIndex() {
        return this.index;
    }

    @Override
    public long getLongPosition(int dim) {
        return IntervalIndexer.indexToPositionWithOffset(this.index, this.dimensions, this.steps, this.min, dim);
    }

    @Override
    public void localize(long[] position) {
        IntervalIndexer.indexToPositionWithOffset(this.index, this.dimensions, this.min, position);
    }

    @Override
    public int getIntPosition(int dim) {
        return (int)IntervalIndexer.indexToPositionWithOffset(this.index, this.dimensions, this.steps, this.min, dim);
    }

    @Override
    public void localize(int[] position) {
        IntervalIndexer.indexToPositionWithOffset(this.index, this.dimensions, this.min, position);
    }

    @Override
    public double getDoublePosition(int dim) {
        return IntervalIndexer.indexToPositionWithOffset(this.index, this.dimensions, this.steps, this.min, dim);
    }

    @Override
    public float getFloatPosition(int dim) {
        return IntervalIndexer.indexToPositionWithOffset(this.index, this.dimensions, this.steps, this.min, dim);
    }

    @Override
    public void localize(float[] position) {
        IntervalIndexer.indexToPositionWithOffset(this.index, this.dimensions, this.min, position);
    }

    @Override
    public void localize(double[] position) {
        IntervalIndexer.indexToPositionWithOffset(this.index, this.dimensions, this.min, position);
    }

    @Override
    public String toString() {
        int[] l = new int[this.dimensions.length];
        this.localize(l);
        return Util.printCoordinates(l);
    }

    @Override
    public long dimension(int d) {
        return this.dimensions[d];
    }

    @Override
    public void dimensions(long[] dim) {
        for (int d = 0; d < this.n; ++d) {
            dim[d] = this.dimensions[d];
        }
    }
}

