/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type;

import java.util.function.Function;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.BooleanAccess;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.img.basictypeaccess.CharAccess;
import net.imglib2.img.basictypeaccess.DoubleAccess;
import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.ShortAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;

public final class NativeTypeFactory<T extends NativeType<T>, A> {
    private final PrimitiveType primitiveType;
    private final Function<NativeImg<T, ? extends A>, T> createLinkedType;

    private NativeTypeFactory(PrimitiveType primitiveType, Function<NativeImg<T, ? extends A>, T> createLinkedType) {
        this.primitiveType = primitiveType;
        this.createLinkedType = createLinkedType;
    }

    public PrimitiveType getPrimitiveType() {
        return this.primitiveType;
    }

    public T createLinkedType(NativeImg<T, ? extends A> img) {
        return (T)((NativeType)this.createLinkedType.apply(img));
    }

    public static <T extends NativeType<T>, A extends BooleanAccess> NativeTypeFactory<T, A> BOOLEAN(Function<NativeImg<T, ? extends A>, T> createLinkedType) {
        return new NativeTypeFactory<T, A>(PrimitiveType.BOOLEAN, createLinkedType);
    }

    public static <T extends NativeType<T>, A extends ByteAccess> NativeTypeFactory<T, A> BYTE(Function<NativeImg<T, ? extends A>, T> createLinkedType) {
        return new NativeTypeFactory<T, A>(PrimitiveType.BYTE, createLinkedType);
    }

    public static <T extends NativeType<T>, A extends CharAccess> NativeTypeFactory<T, A> CHAR(Function<NativeImg<T, ? extends A>, T> createLinkedType) {
        return new NativeTypeFactory<T, A>(PrimitiveType.CHAR, createLinkedType);
    }

    public static <T extends NativeType<T>, A extends ShortAccess> NativeTypeFactory<T, A> SHORT(Function<NativeImg<T, ? extends A>, T> createLinkedType) {
        return new NativeTypeFactory<T, A>(PrimitiveType.SHORT, createLinkedType);
    }

    public static <T extends NativeType<T>, A extends IntAccess> NativeTypeFactory<T, A> INT(Function<NativeImg<T, ? extends A>, T> createLinkedType) {
        return new NativeTypeFactory<T, A>(PrimitiveType.INT, createLinkedType);
    }

    public static <T extends NativeType<T>, A extends LongAccess> NativeTypeFactory<T, A> LONG(Function<NativeImg<T, ? extends A>, T> createLinkedType) {
        return new NativeTypeFactory<T, A>(PrimitiveType.LONG, createLinkedType);
    }

    public static <T extends NativeType<T>, A extends FloatAccess> NativeTypeFactory<T, A> FLOAT(Function<NativeImg<T, ? extends A>, T> createLinkedType) {
        return new NativeTypeFactory<T, A>(PrimitiveType.FLOAT, createLinkedType);
    }

    public static <T extends NativeType<T>, A extends DoubleAccess> NativeTypeFactory<T, A> DOUBLE(Function<NativeImg<T, ? extends A>, T> createLinkedType) {
        return new NativeTypeFactory<T, A>(PrimitiveType.DOUBLE, createLinkedType);
    }
}

