/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.ShortAccess;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Util;

public abstract class GenericShortType<T extends GenericShortType<T>>
extends AbstractIntegerType<T>
implements NativeType<T> {
    final Index i = new Index();
    protected final NativeImg<?, ? extends ShortAccess> img;
    protected ShortAccess dataAccess;

    public GenericShortType(NativeImg<?, ? extends ShortAccess> shortStorage) {
        this.img = shortStorage;
    }

    public GenericShortType(short value) {
        this.img = null;
        this.dataAccess = new ShortArray(1);
        this.setShort(value);
    }

    public GenericShortType(ShortAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public GenericShortType() {
        this(0);
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction();
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public Index index() {
        return this.i;
    }

    @Override
    public abstract NativeTypeFactory<T, ShortAccess> getNativeTypeFactory();

    @Deprecated
    protected short getValue() {
        return this.dataAccess.getValue(this.i.get());
    }

    @Deprecated
    protected void setValue(short f) {
        this.dataAccess.setValue(this.i.get(), f);
    }

    public short getShort() {
        return this.dataAccess.getValue(this.i.get());
    }

    public void setShort(short f) {
        this.dataAccess.setValue(this.i.get(), f);
    }

    @Override
    public void mul(float c) {
        short a = this.getShort();
        this.setShort((short)Util.round((float)a * c));
    }

    @Override
    public void mul(double c) {
        short a = this.getShort();
        this.setShort((short)Util.round((double)a * c));
    }

    @Override
    public void add(T c) {
        short a = this.getShort();
        this.setShort((short)(a + ((GenericShortType)c).getShort()));
    }

    @Override
    public void div(T c) {
        short a = this.getShort();
        this.setShort((short)(a / ((GenericShortType)c).getShort()));
    }

    @Override
    public void mul(T c) {
        short a = this.getShort();
        this.setShort((short)(a * ((GenericShortType)c).getShort()));
    }

    @Override
    public void sub(T c) {
        short a = this.getShort();
        this.setShort((short)(a - ((GenericShortType)c).getShort()));
    }

    @Override
    public void set(T c) {
        this.setShort(((GenericShortType)c).getShort());
    }

    @Override
    public void setOne() {
        this.setShort((short)1);
    }

    @Override
    public void setZero() {
        this.setShort((short)0);
    }

    @Override
    public void inc() {
        short a = this.getShort();
        a = (short)(a + 1);
        this.setShort(a);
    }

    @Override
    public void dec() {
        short a = this.getShort();
        a = (short)(a - 1);
        this.setShort(a);
    }

    @Override
    public String toString() {
        return "" + this.getShort();
    }

    @Override
    public int getBitsPerPixel() {
        return 16;
    }

    @Override
    public int compareTo(T other) {
        return Short.compare(this.getShort(), ((GenericShortType)other).getShort());
    }

    @Override
    public boolean valueEquals(T t) {
        return this.getShort() == ((GenericShortType)t).getShort();
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        GenericShortType t = (GenericShortType)obj;
        return this.valueEquals((T)t);
    }

    @Override
    public int hashCode() {
        return Short.hashCode(this.getShort());
    }
}

