/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.util;

import java.util.ArrayList;
import java.util.Collections;

public class BenchmarkHelper {
    public static ArrayList<Long> benchmark(int numRuns, Runnable benchmark) {
        ArrayList<Long> times = new ArrayList<Long>(numRuns);
        for (int i = 0; i < numRuns; ++i) {
            long startTime = System.currentTimeMillis();
            benchmark.run();
            long endTime = System.currentTimeMillis();
            times.add(endTime - startTime);
        }
        return times;
    }

    public static void benchmarkAndPrint(int numRuns, boolean printIndividualTimes, Runnable b) {
        int i;
        ArrayList<Long> times = new ArrayList<Long>(100);
        for (i = 0; i < numRuns; ++i) {
            long startTime = System.currentTimeMillis();
            b.run();
            long endTime = System.currentTimeMillis();
            times.add(endTime - startTime);
        }
        if (printIndividualTimes) {
            for (i = 0; i < numRuns; ++i) {
                System.out.println("run " + i + ": " + times.get(i) + " ms");
            }
            System.out.println();
        }
        Collections.sort(times);
        System.out.println("median: " + BenchmarkHelper.median(times) + " ms");
        System.out.println("best: " + times.get(0) + " ms");
        System.out.println();
    }

    private static long median(ArrayList<Long> values) {
        if (values.size() % 2 == 1) {
            return values.get((values.size() + 1) / 2 - 1);
        }
        long lower = values.get(values.size() / 2 - 1);
        long upper = values.get(values.size() / 2);
        return (lower + upper) / 2L;
    }
}

