/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.laf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.scijava.module.MutableModuleItem;
import org.scijava.options.OptionsPlugin;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.laf.SwingLookAndFeelService;

@Plugin(type=OptionsPlugin.class, menu={@Menu(label="Edit", weight=1.0, mnemonic=101), @Menu(label="Options", mnemonic=111), @Menu(label="Look and Feel...", weight=100.0, mnemonic=108)})
public class OptionsLookAndFeel
extends OptionsPlugin {
    private static final String LOOK_AND_FEEL = "lookAndFeel";
    @Parameter(required=false)
    private SwingLookAndFeelService lafService;
    @Parameter(label="Look & Feel", persist=false, initializer="initLookAndFeel")
    private String lookAndFeel;

    public String getLookAndFeel() {
        return this.lookAndFeel;
    }

    public void setLookAndFeel(String lookAndFeel) {
        this.lookAndFeel = lookAndFeel;
    }

    public void run() {
        if (this.lafService != null) {
            this.lafService.setLookAndFeel(this.lookAndFeel);
        }
        super.run();
    }

    protected void initLookAndFeel() {
        MutableModuleItem lafItem = this.getInfo().getMutableInput(LOOK_AND_FEEL, String.class);
        LookAndFeel laf = UIManager.getLookAndFeel();
        String string = this.lookAndFeel = laf == null ? "<None>" : laf.getName();
        if (this.lafService == null) {
            lafItem.setChoices(Collections.singletonList(this.lookAndFeel));
        } else {
            UIManager.LookAndFeelInfo[] infos = this.lafService.getLookAndFeels();
            List choices = Arrays.stream(infos).map(info -> info.getName()).collect(Collectors.toList());
            lafItem.setChoices(choices);
        }
    }
}

