/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.scijava.input.Accelerator;
import org.scijava.input.KeyCode;
import org.scijava.menu.AbstractMenuCreator;
import org.scijava.menu.ShadowMenu;
import org.scijava.module.ModuleInfo;

public abstract class AbstractSwingMenuCreator<T>
extends AbstractMenuCreator<T, JMenu> {
    private HashMap<String, ButtonGroup> buttonGroups = new HashMap();

    public void createMenus(ShadowMenu root, T target) {
        this.buttonGroups = new HashMap();
        super.createMenus(root, target);
    }

    protected void addLeafToMenu(ShadowMenu shadow, JMenu target) {
        JMenuItem menuItem = this.createLeaf(shadow);
        target.add(menuItem);
    }

    protected JMenu addNonLeafToMenu(ShadowMenu shadow, JMenu target) {
        JMenu menu = this.createNonLeaf(shadow);
        target.add(menu);
        return menu;
    }

    protected void addSeparatorToMenu(JMenu target) {
        target.addSeparator();
    }

    protected JMenuItem createLeaf(ShadowMenu shadow) {
        String name = shadow.getMenuEntry().getName();
        JMenuItem menuItem = new JMenuItem(name);
        this.assignProperties(menuItem, shadow);
        this.linkAction(shadow, menuItem);
        return menuItem;
    }

    protected JMenu createNonLeaf(ShadowMenu shadow) {
        JMenu menu = new JMenu(shadow.getMenuEntry().getName());
        this.assignProperties(menu, shadow);
        return menu;
    }

    private boolean isSelected(ShadowMenu shadow) {
        return shadow.getModuleInfo().isSelected();
    }

    private ButtonGroup getButtonGroup(ShadowMenu shadow) {
        String selectionGroup = shadow.getModuleInfo().getSelectionGroup();
        ButtonGroup buttonGroup = this.buttonGroups.get(selectionGroup);
        if (buttonGroup == null) {
            buttonGroup = new ButtonGroup();
            this.buttonGroups.put(selectionGroup, buttonGroup);
        }
        return buttonGroup;
    }

    private KeyStroke getKeyStroke(ShadowMenu shadow) {
        Accelerator accelerator = shadow.getMenuEntry().getAccelerator();
        if (accelerator == null || accelerator.getKeyCode() == KeyCode.UNDEFINED) {
            return null;
        }
        return KeyStroke.getKeyStroke(accelerator.toString());
    }

    private Icon loadIcon(ShadowMenu shadow) {
        URL iconURL = shadow.getIconURL();
        return iconURL == null ? null : new ImageIcon(iconURL);
    }

    private void assignProperties(JMenuItem menuItem, ShadowMenu shadow) {
        ModuleInfo info;
        Icon icon;
        KeyStroke keyStroke;
        char mnemonic = shadow.getMenuEntry().getMnemonic();
        if (mnemonic != '\u0000') {
            menuItem.setMnemonic(mnemonic);
        }
        if ((keyStroke = this.getKeyStroke(shadow)) != null) {
            menuItem.setAccelerator(keyStroke);
        }
        if ((icon = this.loadIcon(shadow)) != null) {
            menuItem.setIcon(icon);
        }
        if ((info = shadow.getModuleInfo()) != null) {
            menuItem.setEnabled(info.isEnabled());
        }
    }

    private void linkAction(final ShadowMenu shadow, JMenuItem menuItem) {
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shadow.run();
            }
        });
    }
}

