/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.plot.converter;

import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jfree.chart.JFreeChart;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.ConversionRequest;
import org.scijava.convert.ConvertService;
import org.scijava.convert.Converter;
import org.scijava.plot.Plot;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class, priority=0.0)
public class PlotToBufferedImageConverter
extends AbstractConverter<Plot, BufferedImage> {
    @Parameter
    ConvertService convertService;

    public boolean canConvert(ConversionRequest request) {
        return request.destClass().isAssignableFrom(BufferedImage.class) && Plot.class.isAssignableFrom(request.sourceClass()) && this.convertService.supports((Object)new ConversionRequest(request.sourceObject(), request.sourceType(), JFreeChart.class));
    }

    public <T> T convert(Object o, Class<T> aClass) {
        if (o instanceof Plot && BufferedImage.class.equals(aClass)) {
            BufferedImage t = this.toBufferedImage((Plot)o);
            return (T)t;
        }
        return null;
    }

    private BufferedImage toBufferedImage(Plot plot) {
        BufferedImage image = new BufferedImage(plot.getPreferredWidth(), plot.getPreferredHeight(), 2);
        JFreeChart chart = (JFreeChart)this.convertService.convert((Object)plot, JFreeChart.class);
        chart.draw(image.createGraphics(), (Rectangle2D)new Rectangle2D.Float(0.0f, 0.0f, image.getWidth(), image.getHeight()));
        return image;
    }

    public Class<BufferedImage> getOutputType() {
        return BufferedImage.class;
    }

    public Class<Plot> getInputType() {
        return Plot.class;
    }
}

