/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.viewer.plot.jfreechart;

import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import org.scijava.plot.BarSeries;
import org.scijava.plot.BoxSeries;
import org.scijava.plot.CategoryChart;
import org.scijava.plot.CategoryChartItem;
import org.scijava.plot.LineSeries;
import org.scijava.plot.SeriesStyle;
import org.scijava.ui.awt.AWTColors;
import org.scijava.ui.swing.viewer.plot.jfreechart.RendererModifier;
import org.scijava.ui.swing.viewer.plot.jfreechart.Utils;
import org.scijava.util.ColorRGB;

class CategoryChartGenerator {
    private final CategoryChart chart;
    private final Utils.SortedLabelFactory labelFactory = new Utils.SortedLabelFactory();
    private final CategoryPlot jfcPlot = new CategoryPlot();
    private final LineAndBarDataset lineData;
    private final LineAndBarDataset barData;
    private final BoxDataset boxData;

    private CategoryChartGenerator(CategoryChart chart) {
        this.chart = chart;
        List<Utils.SortedLabel> categoryList = this.setupCategoryList();
        this.lineData = new LineAndBarDataset((AbstractCategoryItemRenderer)new LineAndShapeRenderer(), categoryList);
        this.barData = new LineAndBarDataset((AbstractCategoryItemRenderer)CategoryChartGenerator.createFlatBarRenderer(), categoryList);
        this.boxData = new BoxDataset(categoryList);
    }

    public static JFreeChart run(CategoryChart chart) {
        return new CategoryChartGenerator(chart).getJFreeChart();
    }

    private List<Utils.SortedLabel> setupCategoryList() {
        List categories = this.chart.getCategories();
        ArrayList<Utils.SortedLabel> categoryList = new ArrayList<Utils.SortedLabel>(categories.size());
        Utils.SortedLabelFactory categoryFactory = new Utils.SortedLabelFactory();
        for (Object category : categories) {
            categoryList.add(categoryFactory.newLabel(category));
        }
        return categoryList;
    }

    private JFreeChart getJFreeChart() {
        this.jfcPlot.setDomainAxis(new CategoryAxis(this.chart.categoryAxis().getLabel()));
        this.jfcPlot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        this.jfcPlot.setRangeAxis(Utils.getJFreeChartAxis(this.chart.numberAxis()));
        this.processAllSeries();
        this.lineData.addDatasetToPlot(0);
        this.boxData.addDatasetToPlot(1);
        this.barData.addDatasetToPlot(2);
        return Utils.setupJFreeChart(this.chart.getTitle(), (Plot)this.jfcPlot);
    }

    private static BarRenderer createFlatBarRenderer() {
        BarRenderer jfcBarRenderer = new BarRenderer();
        jfcBarRenderer.setBarPainter((BarPainter)new StandardBarPainter());
        jfcBarRenderer.setShadowVisible(false);
        return jfcBarRenderer;
    }

    private void processAllSeries() {
        for (CategoryChartItem series : this.chart.getItems()) {
            if (series instanceof BarSeries) {
                this.barData.addSeries((BarSeries)series);
            }
            if (series instanceof LineSeries) {
                this.lineData.addSeries((LineSeries)series);
            }
            if (!(series instanceof BoxSeries)) continue;
            this.boxData.addBoxSeries((BoxSeries)series);
        }
    }

    private class LineAndBarDataset {
        private final DefaultCategoryDataset jfcDataset = new DefaultCategoryDataset();
        private final AbstractCategoryItemRenderer jfcRenderer;
        private final List<Utils.SortedLabel> categoryList;

        LineAndBarDataset(AbstractCategoryItemRenderer renderer, List<Utils.SortedLabel> categoryList) {
            this.jfcRenderer = renderer;
            this.categoryList = categoryList;
            this.setCategories();
        }

        private void setCategories() {
            Utils.SortedLabel uniqueLabel = CategoryChartGenerator.this.labelFactory.newLabel("dummy");
            for (Utils.SortedLabel category : this.categoryList) {
                this.jfcDataset.addValue(0.0, (Comparable)uniqueLabel, (Comparable)category);
            }
            this.setSeriesVisibility(uniqueLabel, false, false);
        }

        void addSeries(BarSeries series) {
            Utils.SortedLabel uniqueLabel = CategoryChartGenerator.this.labelFactory.newLabel(series.getLabel());
            this.addSeriesData(uniqueLabel, series.getValues());
            this.setSeriesColor(uniqueLabel, series.getColor());
            this.setSeriesVisibility(uniqueLabel, true, series.getLegendVisible());
        }

        void addSeries(LineSeries series) {
            Utils.SortedLabel uniqueLabel = CategoryChartGenerator.this.labelFactory.newLabel(series.getLabel());
            this.addSeriesData(uniqueLabel, series.getValues());
            this.setSeriesStyle(uniqueLabel, series.getStyle());
            this.setSeriesVisibility(uniqueLabel, true, series.getLegendVisible());
        }

        private void setSeriesVisibility(Utils.SortedLabel uniqueLabel, boolean seriesVsisible, boolean legendVisible) {
            int index = this.jfcDataset.getRowIndex((Comparable)uniqueLabel);
            if (index < 0) {
                return;
            }
            this.jfcRenderer.setSeriesVisible(index, Boolean.valueOf(seriesVsisible), false);
            this.jfcRenderer.setSeriesVisibleInLegend(index, Boolean.valueOf(legendVisible), false);
        }

        private void addSeriesData(Utils.SortedLabel uniqueLabel, Map<?, Double> values) {
            for (Utils.SortedLabel category : this.categoryList) {
                Double value = values.get(category.getLabel());
                if (value == null) continue;
                this.jfcDataset.addValue((Number)value, (Comparable)uniqueLabel, (Comparable)category);
            }
        }

        private void setSeriesStyle(Utils.SortedLabel uniqueLabel, SeriesStyle style) {
            if (style == null) {
                return;
            }
            int index = this.jfcDataset.getRowIndex((Comparable)uniqueLabel);
            if (index < 0) {
                return;
            }
            RendererModifier.wrap((AbstractRenderer)this.jfcRenderer).setSeriesStyle(index, style);
        }

        private void setSeriesColor(Utils.SortedLabel uniqueLabel, ColorRGB style) {
            if (style == null) {
                return;
            }
            int index = this.jfcDataset.getRowIndex((Comparable)uniqueLabel);
            if (index < 0) {
                return;
            }
            RendererModifier.wrap((AbstractRenderer)this.jfcRenderer).setSeriesColor(index, style);
        }

        void addDatasetToPlot(int datasetIndex) {
            CategoryChartGenerator.this.jfcPlot.setDataset(datasetIndex, (CategoryDataset)this.jfcDataset);
            CategoryChartGenerator.this.jfcPlot.setRenderer(datasetIndex, (CategoryItemRenderer)this.jfcRenderer);
        }
    }

    private class BoxDataset {
        private final DefaultBoxAndWhiskerCategoryDataset jfcDataset = new DefaultBoxAndWhiskerCategoryDataset();
        private final BoxAndWhiskerRenderer jfcRenderer = new BoxAndWhiskerRenderer();
        private final List<Utils.SortedLabel> categoryList;

        BoxDataset(List<Utils.SortedLabel> categoryList) {
            this.jfcRenderer.setFillBox(false);
            this.categoryList = categoryList;
            this.setCategories();
        }

        void addBoxSeries(BoxSeries series) {
            Utils.SortedLabel uniqueLabel = CategoryChartGenerator.this.labelFactory.newLabel(series.getLabel());
            this.setSeriesData(uniqueLabel, series.getValues());
            this.setSeriesVisibility(uniqueLabel, true, series.getLegendVisible());
            this.setSeriesColor(uniqueLabel, series.getColor());
        }

        private void setCategories() {
            Utils.SortedLabel uniqueLabel = CategoryChartGenerator.this.labelFactory.newLabel("dummy");
            for (Utils.SortedLabel category : this.categoryList) {
                this.jfcDataset.add(Collections.emptyList(), (Comparable)uniqueLabel, (Comparable)category);
            }
            this.setSeriesVisibility(uniqueLabel, false, false);
        }

        private void setSeriesData(Utils.SortedLabel uniqueLabel, Map<?, ? extends Collection<Double>> data) {
            for (Utils.SortedLabel category : this.categoryList) {
                Collection<Double> value = data.get(category.getLabel());
                if (value == null) continue;
                this.jfcDataset.add(new ArrayList<Double>(value), (Comparable)uniqueLabel, (Comparable)category);
            }
        }

        private void setSeriesColor(Utils.SortedLabel uniqueLabel, ColorRGB color) {
            if (color == null) {
                return;
            }
            int index = this.jfcDataset.getRowIndex((Comparable)uniqueLabel);
            if (index < 0) {
                return;
            }
            this.jfcRenderer.setSeriesPaint(index, (Paint)AWTColors.getColor((ColorRGB)color));
        }

        private void setSeriesVisibility(Utils.SortedLabel uniqueLabel, boolean seriesVsisible, boolean legendVisible) {
            int index = this.jfcDataset.getRowIndex((Comparable)uniqueLabel);
            if (index < 0) {
                return;
            }
            this.jfcRenderer.setSeriesVisible(index, Boolean.valueOf(seriesVsisible), false);
            this.jfcRenderer.setSeriesVisibleInLegend(index, Boolean.valueOf(legendVisible), false);
        }

        void addDatasetToPlot(int datasetIndex) {
            CategoryChartGenerator.this.jfcPlot.setDataset(datasetIndex, (CategoryDataset)this.jfcDataset);
            CategoryChartGenerator.this.jfcPlot.setRenderer(datasetIndex, (CategoryItemRenderer)this.jfcRenderer);
        }
    }
}

