/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import javax.swing.SpinnerNumberModel;

public abstract class SpinnerTypedNumberModel<T extends Number>
extends SpinnerNumberModel {
    private final Class<T> type;
    private T value;
    private Comparable<T> min;
    private Comparable<T> max;
    private T stepSize;

    public SpinnerTypedNumberModel(Class<T> type, T value, Comparable<T> min, Comparable<T> max, T stepSize) {
        super((Number)value, min, max, (Number)stepSize);
        this.type = type;
        this.value = value;
        this.min = min;
        this.max = max;
        this.stepSize = stepSize;
    }

    protected abstract T stepUp();

    protected abstract T stepDown();

    public Comparable<T> getMaximum() {
        return this.max;
    }

    public Comparable<T> getMinimum() {
        return this.min;
    }

    public T getNextValue() {
        T newValue = this.stepUp();
        if (this.max != null && this.max.compareTo(newValue) < 0) {
            return null;
        }
        return newValue;
    }

    public T getNumber() {
        return this.value;
    }

    public T getPreviousValue() {
        T newValue = this.stepDown();
        if (this.min != null && this.min.compareTo(newValue) > 0) {
            return null;
        }
        return newValue;
    }

    public T getStepSize() {
        return this.stepSize;
    }

    public T getValue() {
        return this.value;
    }

    public void setMaximum(Comparable maximum) {
        this.max = maximum;
        super.setMaximum(maximum);
    }

    public void setMinimum(Comparable minimum) {
        this.min = minimum;
        super.setMinimum(minimum);
    }

    @Override
    public void setStepSize(Number stepSize) {
        if (stepSize == null || !this.type.isInstance(stepSize)) {
            throw new IllegalArgumentException("illegal value");
        }
        Number typedStepSize = stepSize;
        this.stepSize = typedStepSize;
        super.setStepSize(stepSize);
    }

    @Override
    public void setValue(Object value) {
        if (value == null || !this.type.isInstance(value)) {
            throw new IllegalArgumentException("illegal value");
        }
        Number typedValue = (Number)value;
        this.value = typedValue;
        super.setValue(value);
    }
}

