/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kymographBuilder;

import ij.gui.Roi;
import io.scif.services.DatasetIOService;
import net.imagej.Dataset;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayService;
import net.imagej.patcher.LegacyInjector;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.UIService;
import sc.fiji.kymographBuilder.KymographFactory;
import sc.fiji.kymographBuilder.NoLineException;
import sc.fiji.kymographBuilder.Utils;

@Plugin(type=Command.class, menuPath="Plugins>Kymograph>KymographBuilder")
public class KymographBuilder
implements Command {
    @Parameter
    private Context ctx;
    @Parameter
    private LogService log;
    @Parameter
    private StatusService statusService;
    @Parameter
    private DatasetIOService datasetIOService;
    @Parameter
    private UIService ui;
    @Parameter
    private ImageDisplayService idService;
    @Parameter
    private OverlayService overlayService;
    @Parameter(type=ItemIO.INPUT)
    private Dataset input;
    @Parameter(type=ItemIO.OUTPUT)
    private Dataset kymograph;
    public static final String PLUGIN_NAME = "KymographBuilder";
    public static final String VERSION;

    private static String version() {
        String version = null;
        Package pack = KymographBuilder.class.getPackage();
        if (pack != null) {
            version = pack.getImplementationVersion();
        }
        return version == null ? "DEVELOPMENT" : version;
    }

    public void run() {
        this.log.info((Object)("Running KymographBuilder version " + VERSION));
        if (this.input.numDimensions() < 3) {
            this.log.error((Object)"The image must have at least 3 dimensions.");
            return;
        }
        Roi roi = null;
        try {
            roi = Utils.checkForROIs(this.input);
        }
        catch (NoLineException exc) {
            this.log.error((Throwable)exc);
            return;
        }
        Utils.swapTimeAndZDimensions(this.input);
        this.log.info((Object)Utils.getInfo(this.input, "\t"));
        KymographFactory factory = new KymographFactory(this.ctx, this.input, roi);
        factory.build();
        this.kymograph = factory.getKymograph();
        this.log.info((Object)("Kymograph \"" + this.kymograph + "\" has been correctly generated."));
    }

    static {
        LegacyInjector.preinit();
        VERSION = KymographBuilder.version();
    }
}

