/*
 * Decompiled with CFR 0.152.
 */
package graphcut;

public class Graph {
    private int numNodes;
    private int numEdges;
    public static final int NONE = -1;
    public static final int TERMINAL = -2;
    public static final int ORPHAN = -3;
    private int[] firstOutgoings;
    private int[] parents;
    private int[] nextNodes;
    private int[] timestamps;
    private int[] distances;
    private boolean[] inSink;
    private boolean[] marked;
    private boolean[] inChangedList;
    private float[] residualNodeCapacities;
    private int[] heads;
    private int[] nextEdges;
    private int[] sisters;
    private float[] residualEdgeCapacities;

    public Graph(int numNodes, int numEdges) {
        int i;
        this.numNodes = numNodes;
        this.numEdges = numEdges;
        this.firstOutgoings = new int[numNodes];
        this.parents = new int[numNodes];
        this.nextNodes = new int[numNodes];
        this.timestamps = new int[numNodes];
        this.distances = new int[numNodes];
        this.inSink = new boolean[numNodes];
        this.marked = new boolean[numNodes];
        this.inChangedList = new boolean[numNodes];
        this.residualNodeCapacities = new float[2 * numEdges];
        this.heads = new int[2 * numEdges];
        this.nextEdges = new int[2 * numEdges];
        this.sisters = new int[2 * numEdges];
        this.residualEdgeCapacities = new float[2 * numEdges];
        for (i = 0; i < numNodes; ++i) {
            this.firstOutgoings[i] = -1;
            this.parents[i] = -1;
            this.nextNodes[i] = -1;
            this.timestamps[i] = 0;
            this.distances[i] = 0;
            this.inSink[i] = false;
            this.marked[i] = false;
            this.residualNodeCapacities[i] = 0.0f;
        }
        for (i = 0; i < 2 * numEdges; ++i) {
            this.heads[i] = -1;
            this.nextEdges[i] = -1;
            this.sisters[i] = -1;
            this.residualEdgeCapacities[i] = 0.0f;
        }
    }

    public final float getResidualNodeCapacity(int node) {
        return this.residualNodeCapacities[node];
    }

    public final void setResidualNodeCapacity(int node, float capacity) {
        this.residualNodeCapacities[node] = capacity;
    }

    public final float getResidualEdgeCapacity(int edge) {
        return this.residualEdgeCapacities[edge];
    }

    public final void setResidualEdgeCapacity(int edge, float capacity) {
        this.residualEdgeCapacities[edge] = capacity;
    }

    public final int getParent(int node) {
        return this.parents[node];
    }

    public final void setParent(int node, int edge) {
        this.parents[node] = edge;
    }

    public final int getSister(int edge) {
        return this.sisters[edge];
    }

    public final void setSister(int edge, int sister) {
        this.sisters[edge] = sister;
    }

    public final int getNextNode(int node) {
        return this.nextNodes[node];
    }

    public final void setNextNode(int node, int next) {
        this.nextNodes[node] = next;
    }

    public final int getNextEdge(int edge) {
        return this.nextEdges[edge];
    }

    public final void setNextEdge(int edge, int next) {
        this.nextEdges[edge] = next;
    }

    public final int getFirstOutgoing(int node) {
        return this.firstOutgoings[node];
    }

    public final void setFirstOutgoing(int node, int edge) {
        this.firstOutgoings[node] = edge;
    }

    public final int getHead(int edge) {
        return this.heads[edge];
    }

    public final void setHead(int edge, int head) {
        this.heads[edge] = head;
    }

    public final boolean isInSink(int node) {
        return this.inSink[node];
    }

    public final void isInSink(int node, boolean isIn) {
        this.inSink[node] = isIn;
    }

    public final int getTimestamp(int node) {
        return this.timestamps[node];
    }

    public final void setTimestamp(int node, int time) {
        this.timestamps[node] = time;
    }

    public final int getDistance(int node) {
        return this.distances[node];
    }

    public final void setDistance(int node, int distance) {
        this.distances[node] = distance;
    }

    public final boolean isInChangedList(int node) {
        return this.inChangedList[node];
    }

    public final void isInChangedList(int node, boolean isIn) {
        this.inChangedList[node] = isIn;
    }

    public final int getNumNodes() {
        return this.numNodes;
    }

    public final int getNumEdges() {
        return this.numEdges;
    }

    public final boolean isMarked(int node) {
        return this.marked[node];
    }

    public final void isMarked(int node, boolean is) {
        this.marked[node] = is;
    }
}

