/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SkipHashedLines
extends BufferedInputStream {
    protected boolean atLineStart = true;

    public SkipHashedLines(InputStream in) {
        super(in, 1024);
    }

    @Override
    public synchronized int read() throws IOException {
        int ch = super.read();
        if (this.atLineStart) {
            if (ch == 35) {
                while ((ch = this.read()) != 10 && ch != -1) {
                }
            } else {
                this.atLineStart = false;
            }
        } else if (ch == 10) {
            this.atLineStart = true;
        }
        return ch;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int count;
        for (count = 0; count < len; ++count) {
            int ch = this.read();
            if (ch < 0) {
                return count == 0 ? -1 : count;
            }
            b[off + count] = (byte)ch;
        }
        return count;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        throw new IOException("unsupported skip");
    }
}

