/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Patch;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.ProjectToolbar;
import ini.trakem2.utils.Utils;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.util.Collection;

public class FakeImagePlus
extends ImagePlus {
    private int w;
    private int h;
    private Display display;
    private int type;

    public FakeImagePlus(int width, int height, Display display) {
        this.w = width;
        this.h = height;
        this.display = display;
        this.setProcessor("", (ImageProcessor)new FakeProcessor(width, height));
        this.type = 0;
    }

    public void setProcessor(String title, ImageProcessor ip) {
        if (!(ip instanceof FakeProcessor)) {
            return;
        }
        super.setProcessor(title, ip);
    }

    public void flush() {
    }

    protected Display getDisplay() {
        return this.display;
    }

    public int getType() {
        return this.type;
    }

    public int getWidth() {
        if (Utils.caller((Object)this).endsWith("ImageCanvas")) {
            return 4;
        }
        return this.w;
    }

    public int getHeight() {
        if (Utils.caller((Object)this).endsWith("ImageCanvas")) {
            return 4;
        }
        return this.h;
    }

    public void setDimensions(int width, int height) {
        this.w = width;
        this.h = height;
    }

    public int[] getPixel(int x, int y) {
        try {
            return ((FakeProcessor)this.getProcessor()).getPixel(this.display.getCanvas().getMagnification(), x, y, null);
        }
        catch (Exception e) {
            IJError.print(e);
            return new int[4];
        }
    }

    private final String doubleToString(double n) {
        return n == (double)((int)n) ? Integer.toString((int)n) : IJ.d2s((double)n);
    }

    public void mouseMoved(int x, int y) {
        Calibration cal = this.getCalibration();
        StringBuilder sb = new StringBuilder(64).append("x=").append(this.doubleToString(cal.getX((double)x))).append(' ').append(cal.getUnit()).append(", y=").append(this.doubleToString(cal.getY((double)y))).append(' ').append(cal.getUnit());
        if (ProjectToolbar.getToolId() <= 10) {
            sb.append(", value=");
            int[] v = this.getPixel(x, y);
            switch (this.type) {
                case 0: 
                case 1: {
                    sb.append(v[0]);
                    break;
                }
                case 3: 
                case 4: {
                    sb.append(v[0]).append(',').append(v[1]).append(',').append(v[2]);
                    break;
                }
                case 2: {
                    sb.append(Float.intBitsToFloat(v[0]));
                    break;
                }
                default: {
                    sb.setLength(sb.length() - 8);
                }
            }
        }
        IJ.showStatus((String)sb.toString());
    }

    public ImageStatistics getStatistics(int mOptions, int nBins, double histMin, double histMax) {
        Displayable active = this.display.getActive();
        if (null == active || !(active instanceof Patch)) {
            Utils.log("No patch selected.");
            return super.getStatistics(mOptions, nBins, histMin, histMax);
        }
        ImagePlus imp = active.getProject().getLoader().fetchImagePlus((Patch)active);
        ImageProcessor ip = imp.getProcessor();
        Roi roi = super.getRoi();
        if (null != roi) {
            int patch_x = active.getX();
            int patch_y = active.getY();
            Rectangle r = roi.getBounds();
            roi.setLocation(patch_x - r.x, patch_y - r.y);
        }
        ip.setRoi(roi);
        ip.setHistogramSize(nBins);
        Calibration cal = this.getCalibration();
        if (this.getType() == 1 && (histMin != 0.0 || histMax != 0.0)) {
            histMin = cal.getRawValue(histMin);
            histMax = cal.getRawValue(histMax);
        }
        ip.setHistogramRange(histMin, histMax);
        ImageStatistics stats = ImageStatistics.getStatistics((ImageProcessor)ip, (int)mOptions, (Calibration)cal);
        ip.setHistogramSize(256);
        ip.setHistogramRange(0.0, 0.0);
        return stats;
    }

    public ImageStack getStack() {
        return null;
    }

    public int getStackCount() {
        return 1;
    }

    public boolean isVirtual() {
        return true;
    }

    public ImageProcessor getProcessor() {
        return super.getProcessor();
    }

    public void setCalibration(Calibration cal) {
        try {
            super.setCalibration(cal);
        }
        catch (Throwable e) {
            IJError.print(e);
        }
        this.display.getLayer().getParent().setCalibration(cal);
    }

    public void setCalibrationSuper(Calibration cal) {
        super.setCalibration(cal);
    }

    public Calibration getCalibration() {
        if (null == this.display || null == this.display.getLayer()) {
            return new Calibration();
        }
        return this.display.getLayer().getParent().getCalibrationCopy();
    }

    public void killRoi() {
        if (null != this.roi) {
            this.saveRoi();
            this.roi = null;
            ImageProcessor ip = this.getProcessor();
            if (null != ip) {
                ip.resetRoi();
            }
        }
    }

    public synchronized void setSlice(int slice) {
    }

    public void updateAndRepaintWindow() {
        Display.repaint(this.display.getLayer(), this.display.getSelection().getBox(), 0);
    }

    private class FakeProcessor
    extends ByteProcessor {
        FakeProcessor(int width, int height) {
            super(4, 4);
        }

        public int getPixel(int x, int y) {
            return this.getPixel(FakeImagePlus.this.display.getCanvas().getMagnification(), x, y);
        }

        public int getPixel(double mag, int x, int y) {
            Collection<Displayable> under = FakeImagePlus.this.display.getLayer().find(Patch.class, x, y, true);
            if (null == under || under.isEmpty()) {
                return 0;
            }
            for (Patch patch : under) {
                if (!patch.isVisible()) continue;
                FakeImagePlus.this.type = patch.getType();
                return patch.getPixel(mag, x, y);
            }
            FakeImagePlus.this.type = 0;
            return 0;
        }

        public int[] getPixel(int x, int y, int[] iArray) {
            return this.getPixel(1.0, x, y, iArray);
        }

        public int[] getPixel(double mag, int x, int y, int[] iArray) {
            Collection<Displayable> under = FakeImagePlus.this.display.getLayer().find(Patch.class, x, y, true);
            if (null != under && !under.isEmpty()) {
                for (Patch patch : under) {
                    if (!patch.isVisible()) continue;
                    FakeImagePlus.this.type = patch.getType();
                    return patch.getPixel(mag, x, y, iArray);
                }
            }
            FakeImagePlus.this.type = 0;
            return new int[4];
        }

        public int getWidth() {
            return FakeImagePlus.this.w;
        }

        public int getHeight() {
            return FakeImagePlus.this.h;
        }

        public void setColorModel(ColorModel cm) {
            FakeImagePlus.this.display.getSelection().setLut(cm);
        }

        public void setPixels(Object ob) {
        }
    }
}

