/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.IJ;
import ij.ImagePlus;
import ij.process.ImageProcessor;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.ImageData;
import ini.trakem2.display.Layer;
import ini.trakem2.display.MipMapImage;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import mpicbg.ij.stack.InverseTransformMapping;
import mpicbg.ij.util.Filter;
import mpicbg.models.AffineModel2D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.Boundable;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.InvertibleCoordinateTransformList;
import mpicbg.models.TranslationModel3D;
import mpicbg.util.Util;

public class Stack
extends ZDisplayable
implements ImageData {
    private String file_path;
    private double depth = -1.0;
    private double min;
    private double max;
    private mpicbg.trakem2.transform.InvertibleCoordinateTransform ict;
    private final double[] boundsMin = new double[]{0.0, 0.0, 0.0};
    private final double[] boundsMax = new double[]{0.0, 0.0, 0.0};
    private double ictScale = 1.0;
    private final HashMap<SliceViewKey, Long> cachedImages = new HashMap();
    private final HashMap<Long, Future<Image>> futureImages = new HashMap();

    public Stack(Project project, String title, double x, double y, Layer initial_layer, String file_path) {
        super(project, title, x, y);
        this.file_path = file_path;
        ImagePlus imp = project.getLoader().fetchImagePlus(this);
        this.depth = imp.getNSlices();
        this.width = imp.getWidth();
        this.height = imp.getHeight();
        this.min = imp.getDisplayRangeMin();
        this.max = imp.getDisplayRangeMax();
        this.boundsMin[0] = 0.0;
        this.boundsMin[1] = 0.0;
        this.boundsMin[2] = initial_layer.getZ();
        this.boundsMax[0] = this.width;
        this.boundsMax[1] = this.height;
        this.boundsMax[2] = this.boundsMin[2] + this.depth;
        this.addToDatabase();
    }

    private Stack(Project project, long id, String title, AffineTransform at, float width, float height, float alpha, boolean visible, Color color, boolean locked, double depth, double min, double max, double[] boundsMin, double[] boundsMax, mpicbg.trakem2.transform.InvertibleCoordinateTransform ict, double ictScale, String file_path) {
        super(project, id, title, locked, at, 0.0f, 0.0f);
        this.title = title;
        this.alpha = alpha;
        this.visible = visible;
        this.color = color;
        this.boundsMin[0] = boundsMin[0];
        this.boundsMin[1] = boundsMin[1];
        this.boundsMin[2] = boundsMin[2];
        this.boundsMax[0] = boundsMax[0];
        this.boundsMax[1] = boundsMax[1];
        this.boundsMax[2] = boundsMax[2];
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.min = min;
        this.max = max;
        this.ict = null == ict ? null : this.ict.copy();
        this.file_path = file_path;
    }

    public Stack(Project project, long id, HashMap<String, String> ht, HashMap<Displayable, String> ht_links) {
        super(project, id, ht, ht_links);
        for (Map.Entry<String, String> entry : ht.entrySet()) {
            String key = entry.getKey();
            String data = entry.getValue();
            if (key.equals("min")) {
                this.min = Double.parseDouble(data);
                continue;
            }
            if (key.equals("max")) {
                this.max = Double.parseDouble(data);
                continue;
            }
            if (key.equals("file_path")) {
                this.file_path = project.getLoader().makeRelativePath(data);
                continue;
            }
            if (!key.equals("depth")) continue;
            this.depth = Double.parseDouble(data);
        }
        this.boundsMin[0] = 0.0;
        this.boundsMin[1] = 0.0;
        this.boundsMin[2] = 0.0;
        this.boundsMax[0] = this.width;
        this.boundsMax[1] = this.height;
        this.boundsMax[2] = this.depth;
    }

    public mpicbg.trakem2.transform.InvertibleCoordinateTransform getInvertibleCoordinateTransform() {
        return this.ict;
    }

    @Override
    public Layer getFirstLayer() {
        return null;
    }

    @Override
    public boolean intersects(Area area, double z_first, double z_last) {
        return false;
    }

    @Override
    public boolean linkPatches() {
        return false;
    }

    @Override
    public Displayable clone(Project pr, boolean copy_id) {
        long nid = copy_id ? this.id : pr.getLoader().getNextId();
        Stack copy = new Stack(pr, nid, null != this.title ? this.title.toString() : null, new AffineTransform(this.at), this.width, this.height, this.alpha, this.visible, this.color, this.locked, this.depth, this.min, this.max, this.boundsMin, this.boundsMax, this.ict, this.ictScale, this.file_path);
        copy.cachedImages.putAll(this.cachedImages);
        copy.futureImages.putAll(this.futureImages);
        copy.addToDatabase();
        return copy;
    }

    @Override
    public boolean isDeletable() {
        return 0.0f == this.width && 0.0f == this.height;
    }

    public String getFilePath() {
        return this.file_path;
    }

    public void setFilePath(String path) {
        this.file_path = path;
        this.project.getLoader().decacheImagePlus(this.id);
        this.invalidateCache();
    }

    public long estimateImageFileSize() {
        if (-1.0 == this.depth) {
            return IJ.maxMemory() / 2L;
        }
        return (long)((double)(this.width * this.height) * this.depth * 4.0);
    }

    private static final double estimateAffineScale(AffineTransform atp) {
        double dxx = atp.getScaleX();
        double dxy = atp.getShearY();
        double dxs = dxx * dxx + dxy * dxy;
        double dyx = atp.getShearX();
        double dyy = atp.getScaleY();
        double dys = dyx * dyx + dyy * dyy;
        return Math.sqrt(Math.max(dxs, dys));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> layers) {
        MipMapImage mipMap = null;
        Future<Image> fu = null;
        SliceViewKey sliceViewKey = new SliceViewKey(magnification, active_layer.getZ());
        HashMap<SliceViewKey, Long> hashMap = this.cachedImages;
        synchronized (hashMap) {
            long imageId;
            Long imageIdL = this.cachedImages.get(sliceViewKey);
            if (imageIdL == null) {
                imageId = this.project.getLoader().getNextTempId();
                this.cachedImages.put(sliceViewKey, imageId);
            } else {
                imageId = imageIdL;
                mipMap = this.project.getLoader().getCached(this.cachedImages.get(sliceViewKey), 0);
            }
            if (mipMap == null) {
                fu = this.fetchFutureImage(imageId, magnification, active_layer, false);
            }
        }
        if (null != mipMap) {
            this.paint(g, mipMap.image);
        } else if (null != fu) {
            Image image;
            try {
                image = fu.get();
            }
            catch (Throwable ie) {
                IJ.log((String)("Could not paint Stack " + this));
                IJError.print(ie);
                return;
            }
            this.paint(g, image);
        } else {
            Utils.log2("Stack.paint ERROR: no image to paint!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Future<Image> fetchFutureImage(final Long imageId, final double magnification, final Layer active_layer, final boolean trigger_repaint_event) {
        HashMap<Long, Future<Image>> hashMap = this.futureImages;
        synchronized (hashMap) {
            Future<Image> fu = this.futureImages.get(imageId);
            if (null == fu) {
                fu = this.project.getLoader().doLater(new Callable<Image>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Image call() {
                        Image image;
                        InverseTransformMapping mapping;
                        InvertibleCoordinateTransformList ictl = new InvertibleCoordinateTransformList();
                        if (Stack.this.ict != null) {
                            ictl.add((InvertibleCoordinateTransform)Stack.this.ict);
                            TranslationModel3D unShiftBounds = new TranslationModel3D();
                            unShiftBounds.set(-Stack.this.boundsMin[0], -Stack.this.boundsMin[1], 0.0);
                            ictl.add((InvertibleCoordinateTransform)unShiftBounds);
                            if (Stack.this.ictScale != 1.0) {
                                AffineModel3D unScaleXY = new AffineModel3D();
                                unScaleXY.set(1.0 / Stack.this.ictScale, 0.0, 0.0, 0.0, 0.0, 1.0 / Stack.this.ictScale, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
                                ictl.add((InvertibleCoordinateTransform)unScaleXY);
                            }
                        }
                        ImagePlus imp = Stack.this.project.getLoader().fetchImagePlus(Stack.this);
                        ImageProcessor ip = imp.getStack().getProcessor(1).createProcessor((int)Math.ceil((Stack.this.boundsMax[0] - Stack.this.boundsMin[0]) / Stack.this.ictScale), (int)Math.ceil((Stack.this.boundsMax[1] - Stack.this.boundsMin[1]) / Stack.this.ictScale));
                        double currentZ = active_layer.getZ();
                        TranslationModel3D sliceShift = new TranslationModel3D();
                        sliceShift.set(0.0, 0.0, -currentZ);
                        ictl.add((InvertibleCoordinateTransform)sliceShift);
                        if (AffineModel3D.class.isInstance(Stack.this.ict)) {
                            AffineModel3D ictAffine = new AffineModel3D();
                            boolean isAffine = true;
                            for (InvertibleCoordinateTransform t : ictl.getList(null)) {
                                if (AffineModel3D.class.isInstance(t)) {
                                    ictAffine.preConcatenate((AffineModel3D)t);
                                    continue;
                                }
                                if (TranslationModel3D.class.isInstance(t)) {
                                    ictAffine.preConcatenate((TranslationModel3D)t);
                                    continue;
                                }
                                isAffine = false;
                                break;
                            }
                            mapping = isAffine ? new InverseTransformMapping((InverseCoordinateTransform)ictAffine) : new InverseTransformMapping((InverseCoordinateTransform)ictl);
                        } else {
                            mapping = new InverseTransformMapping((InverseCoordinateTransform)ictl);
                        }
                        mapping.mapInterpolated(imp.getStack(), ip);
                        double s = Stack.estimateAffineScale(new AffineTransform(Stack.this.at));
                        double smoothMag = magnification * s * Stack.this.ictScale;
                        if (smoothMag < 1.0) {
                            Filter.smoothForScale((ImageProcessor)ip, (double)smoothMag, (float)0.5f, (float)0.5f);
                        }
                        if (null == (image = ip.createImage())) {
                            Utils.log2("Stack.paint: null image, returning");
                            return null;
                        }
                        Stack.this.project.getLoader().cacheAWT(imageId, image);
                        HashMap hashMap = Stack.this.futureImages;
                        synchronized (hashMap) {
                            Stack.this.futureImages.remove(imageId);
                        }
                        if (trigger_repaint_event) {
                            Display.repaint(active_layer);
                        }
                        return image;
                    }
                });
            }
            this.futureImages.put(imageId, fu);
            return fu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prePaint(Graphics2D g, Rectangle srcRect, double magnification, boolean active, int channels, Layer active_layer, List<Layer> _ignored) {
        double currentZ = active_layer.getZ();
        MipMapImage mipMap = null;
        HashMap<SliceViewKey, Long> hashMap = this.cachedImages;
        synchronized (hashMap) {
            long imageId;
            SliceViewKey sliceViewKey = new SliceViewKey(magnification, currentZ);
            Long imageIdL = this.cachedImages.get(sliceViewKey);
            if (imageIdL == null) {
                imageId = this.project.getLoader().getNextTempId();
                this.cachedImages.put(sliceViewKey, imageId);
            } else {
                imageId = imageIdL;
                mipMap = this.project.getLoader().getCached(this.cachedImages.get(sliceViewKey), 0);
            }
            if (mipMap == null) {
                this.fetchFutureImage(imageId, magnification, active_layer, true);
                return;
            }
        }
        if (mipMap != null) {
            this.paint(g, mipMap.image);
        }
    }

    private final void paint(Graphics2D g, Image image) {
        AffineTransform atp = new AffineTransform(this.at);
        AffineTransform shiftBounds = new AffineTransform(1.0, 0.0, 0.0, 1.0, this.boundsMin[0], this.boundsMin[1]);
        atp.concatenate(shiftBounds);
        AffineTransform asict = new AffineTransform(this.ictScale, 0.0, 0.0, this.ictScale, 0.0, 0.0);
        atp.concatenate(asict);
        Composite original_composite = g.getComposite();
        try {
            g.setComposite(this.getComposite(this.getCompositeMode()));
            g.drawImage(image, atp, null);
        }
        catch (Throwable t) {
            Utils.log("Cannot paint Stack with composite type " + compositeModes[this.getCompositeMode()] + "\nReason:\n" + t.toString());
            g.setComposite(this.getComposite((byte)0));
            g.drawImage(image, atp, null);
        }
        g.setComposite(original_composite);
    }

    public static final void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        String type = "t2_stack";
        if (hs.contains("t2_stack")) {
            return;
        }
        hs.add("t2_stack");
        sb_header.append(indent).append("<!ELEMENT t2_stack (").append(Displayable.commonDTDChildren()).append(",(iict_transform|iict_transform_list)?)>\n");
        Displayable.exportDTD("t2_stack", sb_header, hs, indent);
        sb_header.append(indent).append("<!ATTLIST ").append("t2_stack").append(" file_path CDATA #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_stack").append(" depth CDATA #REQUIRED>\n");
    }

    @Override
    public void exportXML(StringBuilder sb_body, String indent, XMLOptions options) {
        String in = indent + "\t";
        sb_body.append(indent).append("<t2_stack\n");
        super.exportXML(sb_body, in, options);
        String[] RGB = Utils.getHexRGBColor(this.color);
        sb_body.append(in).append("file_path=\"").append(this.file_path).append("\"\n").append(in).append("style=\"fill-opacity:").append(this.alpha).append(";stroke:#").append(RGB[0]).append(RGB[1]).append(RGB[2]).append(";\"\n").append(in).append("depth=\"").append(this.depth).append("\"\n").append(in).append("min=\"").append(this.min).append("\"\n").append(in).append("max=\"").append(this.max).append("\"\n");
        sb_body.append(indent).append(">\n");
        if (null != this.ict) {
            sb_body.append(this.ict.toXML(in)).append('\n');
        }
        super.restXML(sb_body, in, options);
        sb_body.append(indent).append("</t2_stack>\n");
    }

    @Override
    protected Rectangle getBounds(Rectangle rect) {
        AffineModel2D a = new AffineModel2D();
        a.set(this.at);
        double[] rMin = new double[]{Double.MAX_VALUE, Double.MAX_VALUE};
        double[] rMax = new double[]{-1.7976931348623157E308, -1.7976931348623157E308};
        double[] l = new double[]{this.boundsMin[0], this.boundsMin[1]};
        a.applyInPlace(l);
        Util.min((double[])rMin, (double[])l);
        Util.max((double[])rMax, (double[])l);
        l[0] = this.boundsMin[0];
        l[1] = this.boundsMax[1];
        a.applyInPlace(l);
        Util.min((double[])rMin, (double[])l);
        Util.max((double[])rMax, (double[])l);
        l[0] = this.boundsMax[0];
        l[1] = this.boundsMin[1];
        a.applyInPlace(l);
        Util.min((double[])rMin, (double[])l);
        Util.max((double[])rMax, (double[])l);
        l[0] = this.boundsMax[0];
        l[1] = this.boundsMax[1];
        a.applyInPlace(l);
        Util.min((double[])rMin, (double[])l);
        Util.max((double[])rMax, (double[])l);
        rect.x = (int)rMin[0];
        rect.y = (int)rMin[1];
        rect.width = (int)Math.ceil(rMax[0] - (double)rect.x);
        rect.height = (int)Math.ceil(rMax[1] - (double)rect.y);
        return rect;
    }

    private void update() {
        this.boundsMin[0] = 0.0;
        this.boundsMin[1] = 0.0;
        this.boundsMin[2] = 0.0;
        this.boundsMax[0] = this.width;
        this.boundsMax[1] = this.height;
        this.boundsMax[2] = this.depth;
        if (this.ict == null) {
            return;
        }
        if (Boundable.class.isInstance(this.ict)) {
            ((Boundable)this.ict).estimateBounds(this.boundsMin, this.boundsMax);
        } else {
            Utils.log2(this.ict + " is not a boundable");
            ArrayList<Layer> layers = this.layer_set.getLayers();
            this.boundsMax[0] = this.layer_set.width;
            this.boundsMax[1] = this.layer_set.height;
            this.boundsMax[2] = layers.get(layers.size() - 1).getZ() - layers.get(0).getZ();
        }
        if (this.ict != null && AffineModel3D.class.isInstance(this.ict)) {
            double[] m = ((AffineModel3D)this.ict).getMatrix(null);
            double dxs = m[0] * m[0] + m[4] * m[4];
            double dys = m[1] * m[1] + m[5] * m[5];
            double dzs = m[2] * m[2] + m[6] * m[6];
            this.ictScale = Math.sqrt(Math.max(dxs, Math.max(dys, dzs)));
        }
    }

    @Override
    public Polygon getPerimeter() {
        Rectangle r = this.getBoundingBox();
        return new Polygon(new int[]{r.x, r.x + r.width, r.x + r.width, r.x}, new int[]{r.y, r.y, r.y + r.height, r.y + r.height}, 4);
    }

    public void setInvertibleCoordinateTransformSilently(mpicbg.trakem2.transform.InvertibleCoordinateTransform ict) {
        this.ict = ict;
        this.update();
    }

    private void invalidateCache() {
        this.cachedImages.clear();
    }

    public void setInvertibleCoordinateTransform(mpicbg.trakem2.transform.InvertibleCoordinateTransform ict) {
        this.invalidateCache();
        this.setInvertibleCoordinateTransformSilently(ict);
    }

    @Override
    public void setAffineTransform(AffineTransform at) {
        this.invalidateCache();
        super.setAffineTransform(at);
    }

    @Override
    public boolean remove2(boolean check) {
        return this.remove(check);
    }

    @Override
    protected boolean calculateBoundingBox(Layer la) {
        return true;
    }

    private static class SliceViewKey {
        final double magnification;
        final double z;

        SliceViewKey(double magnification, double z) {
            this.magnification = magnification;
            this.z = z;
        }

        public final boolean equals(Object o) {
            SliceViewKey k = (SliceViewKey)o;
            return k.magnification == this.magnification && k.z == this.z;
        }

        public final int hashCode() {
            return 0;
        }
    }
}

