/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display.inspect;

import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Mode;
import ini.trakem2.display.Patch;
import ini.trakem2.display.graphics.DefaultGraphicsSource;
import ini.trakem2.display.graphics.GraphicsSource;
import ini.trakem2.display.inspect.ShapeProxy;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.PointMatch;
import mpicbg.trakem2.transform.TransformMesh;

public class InspectPatchTrianglesMode
implements Mode {
    protected final Display display;
    private final DefaultGraphicsSource gs = new DefaultGraphicsSource();
    protected final ShapeProxy proxy = new ShapeProxy(new Rectangle(-1, -1, 0, 0));
    protected final Inspector inspector = new Inspector();

    public InspectPatchTrianglesMode(Display display) {
        this.display = display;
    }

    @Override
    public GraphicsSource getGraphicsSource() {
        return this.gs;
    }

    @Override
    public boolean canChangeLayer() {
        return false;
    }

    @Override
    public boolean canZoom() {
        return true;
    }

    @Override
    public boolean canPan() {
        return true;
    }

    @Override
    public boolean isDragging() {
        return false;
    }

    @Override
    public void undoOneStep() {
    }

    @Override
    public void redoOneStep() {
    }

    @Override
    public void mousePressed(MouseEvent me, int x_p, int y_p, double magnification) {
        this.display.getLayerSet().getOverlay().add(this.proxy, Color.YELLOW, new BasicStroke(1.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent me, int x_p, int y_p, int x_d, int y_d, int x_d_old, int y_d_old) {
        Inspector inspector = this.inspector;
        synchronized (inspector) {
            this.inspector.viewAt(x_d, y_d, this.display.getLayer());
            this.inspector.notifyAll();
        }
    }

    @Override
    public void mouseReleased(MouseEvent me, int x_p, int y_p, int x_d, int y_d, int x_r, int y_r) {
        this.display.getLayerSet().getOverlay().remove(this.proxy);
    }

    @Override
    public void srcRectUpdated(Rectangle srcRect, double magnification) {
    }

    @Override
    public void magnificationUpdated(Rectangle srcRect, double magnification) {
    }

    @Override
    public boolean apply() {
        return this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        this.display.getLayerSet().getOverlay().remove(this.proxy);
        Inspector inspector = this.inspector;
        synchronized (inspector) {
            this.inspector.quit();
            this.inspector.notifyAll();
        }
        return true;
    }

    @Override
    public Rectangle getRepaintBounds() {
        return this.display.getCanvas().getSrcRect();
    }

    protected class Inspector
    extends Thread {
        private boolean quit = false;
        private double wx;
        private double wy;
        private Layer layer;

        Inspector() {
            this.setPriority(5);
            this.start();
        }

        private void quit() {
            this.quit = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void viewAt(double wX, double wY, Layer l) {
            Inspector inspector = this;
            synchronized (inspector) {
                this.wx = wX;
                this.wy = wY;
                this.layer = l;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            double wX = 0.0;
            double wY = 0.0;
            Layer l = null;
            while (!this.isInterrupted()) {
                Patch patch;
                try {
                    Inspector inspector = this;
                    synchronized (inspector) {
                        if (this.wx == wX && this.wy == wY && this.layer == l) {
                            this.wait();
                        }
                    }
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                    return;
                }
                if (this.quit) {
                    return;
                }
                Inspector ie = this;
                synchronized (ie) {
                    wX = this.wx;
                    wY = this.wy;
                    l = this.layer;
                }
                Collection<Displayable> ps = l.find(Patch.class, wX, wY, true, false);
                if (ps.isEmpty() || null == (patch = (Patch)ps.iterator().next()).getCoordinateTransform()) continue;
                double[] f = new double[]{this.wx, this.wy};
                AffineTransform ai = patch.getAffineTransformCopy();
                AffineTransform aiInverse = new AffineTransform(ai);
                try {
                    aiInverse.invert();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
                aiInverse.transform(f, 0, f, 0, 1);
                TransformMesh mesh = new TransformMesh((CoordinateTransform)patch.getCoordinateTransform(), patch.getMeshResolution(), (double)patch.getOWidth(), (double)patch.getOHeight());
                AffineModel2D triangle = mesh.closestTargetAffine(f);
                ArrayList pm = (ArrayList)mesh.getAV().get(triangle);
                GeneralPath path = new GeneralPath();
                double[] p1 = ((PointMatch)pm.get(0)).getP2().getW();
                double[] q = new double[2];
                ai.transform(p1, 0, q, 0, 1);
                path.moveTo(q[0], q[1]);
                for (int i = 1; i < pm.size(); ++i) {
                    double[] p = ((PointMatch)pm.get(i)).getP2().getW();
                    ai.transform(p, 0, q, 0, 1);
                    path.lineTo(q[0], q[1]);
                }
                path.closePath();
                InspectPatchTrianglesMode.this.proxy.set(path);
                InspectPatchTrianglesMode.this.display.getCanvas().repaint(InspectPatchTrianglesMode.this.proxy.getBounds(), 0, false);
            }
        }
    }
}

