/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;

public class IntegralHistogram2d {
    public static final long[] integralHistogram2d(short[] pixels, int width, int height, int nBins, double min, double max) {
        long[] hist = new long[(width + 1) * (height + 1) * nBins];
        double K = (double)nBins / (max - min + 1.0);
        int histWidth = (width + 1) * nBins;
        int i = 0;
        for (int y = 0; y < height; ++y) {
            int offset = histWidth * (y + 1);
            int histIndex = offset + nBins;
            int x = 0;
            while (x < width) {
                int binIndex = (int)(((double)(pixels[i] & 0xFFFF) - min) * K);
                if (binIndex >= nBins) {
                    binIndex = nBins - 1;
                }
                for (int b = 0; b < nBins; ++b) {
                    hist[histIndex + b] = hist[histIndex + b - nBins];
                }
                int n = histIndex + binIndex;
                hist[n] = hist[n] + 1L;
                ++x;
                ++i;
                histIndex += nBins;
            }
        }
        int w = (width + 1) * nBins;
        int h = height + 1;
        for (int y = 1; y < h; ++y) {
            for (int x = nBins; x < w; ++x) {
                int n = y * w + x;
                hist[n] = hist[n] + hist[(y - 1) * w + x];
            }
        }
        return hist;
    }

    public static final short[] median(int width, int height, long[] hist, int nBins, double min, double max, int radius) {
        short[] median = new short[width * height];
        int w = (width + 1) * nBins;
        double binWorth = (max - min + 1.0) / (double)nBins;
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            block1: for (int x = 0; x < width; ++x) {
                int x0 = Math.max(0, x + 1 - radius) * nBins;
                int y0 = Math.max(0, y + 1 - radius);
                int x1 = Math.min(width, x + 1 + radius) * nBins;
                int y1 = Math.max(0, y + 1 - radius);
                int x2 = Math.min(width, x + 1 + radius) * nBins;
                int y2 = Math.min(height, y + 1 + radius);
                int x3 = Math.max(0, x + 1 - radius) * nBins;
                int y3 = Math.min(height, y + 1 + radius);
                int halfHistCount = (int)((double)((x2 - x0 + 1) * (y2 - y0 + 1) / nBins) / 2.0);
                long sum = 0L;
                float val = 0.0f;
                for (int b = 0; b < nBins; ++b) {
                    long binCount = hist[y0 * w + x0 + b] - hist[y1 * w + x1 + b] + hist[y2 * w + x2 + b] - hist[y3 * w + x3 + b];
                    if ((sum += binCount) > (long)halfHistCount) {
                        median[offset + x] = (short)((double)val + binWorth * (double)((float)((long)halfHistCount - (sum - binCount)) / (float)binCount));
                        continue block1;
                    }
                    val = (float)((double)val + binWorth);
                }
            }
        }
        return median;
    }

    private static final void view(long[] hist, int w1, int h1, int nBins) {
        float[] pixels = new float[w1 * h1 * nBins];
        for (int i = 0; i < hist.length; ++i) {
            pixels[i] = hist[i];
        }
        new ImagePlus("Integral Histogram", (ImageProcessor)new FloatProcessor(w1 * nBins, h1, pixels)).show();
    }

    public static final ShortProcessor median(ShortProcessor sp, int nBins, double min, double max, int radius) {
        long[] hist = IntegralHistogram2d.integralHistogram2d((short[])sp.getPixels(), sp.getWidth(), sp.getHeight(), nBins, min, max);
        short[] median = IntegralHistogram2d.median(sp.getWidth(), sp.getHeight(), hist, nBins, min, max, radius);
        return new ShortProcessor(sp.getWidth(), sp.getHeight(), median, null);
    }

    public static final void main(String[] args) {
        ShortProcessor sp = (ShortProcessor)IJ.openImage((String)"/home/albert/Desktop/t2/bridge-16bit.tif").getProcessor();
        ShortProcessor filtered = IntegralHistogram2d.median(sp, 64, 0.0, 65535.0, 100);
        new ImageJ();
        new ImagePlus("median", (ImageProcessor)filtered).show();
    }
}

