/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.transform;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ini.trakem2.display.MipMapImage;
import ini.trakem2.display.Patch;
import ini.trakem2.persistence.Loader;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.util.Arrays;
import java.util.List;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.CoordinateTransformMesh;
import mpicbg.models.TransformMesh;
import mpicbg.trakem2.transform.AffineModel2D;
import mpicbg.trakem2.transform.TransformMeshMappingWithMasks;
import mpicbg.trakem2.util.Pair;

public class ExportARGB {
    public static final Pair<ColorProcessor, ByteProcessor> makeFlatImageARGB(List<Patch> patches, Rectangle roi, double backgroundValue, double scale, boolean use_mipmaps) {
        return use_mipmaps ? ExportARGB.makeFlatImageARGBFromMipMaps(patches, roi, backgroundValue, scale) : ExportARGB.makeFlatImageARGBFromOriginals(patches, roi, backgroundValue, scale);
    }

    public static final int[] extractARGBIntArray(Image img) {
        int[] pix = new int[img.getWidth(null) * img.getHeight(null)];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, img.getWidth(null), img.getHeight(null), pix, 0, img.getWidth(null));
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return pix;
    }

    public static final Pair<ColorProcessor, ByteProcessor> makeFlatImageARGBFromMipMaps(List<Patch> patches, Rectangle roi, double backgroundValue, double scale) {
        int width = (int)((double)roi.width * scale);
        int height = (int)((double)roi.height * scale);
        ColorProcessor target = new ColorProcessor(width, height);
        target.setInterpolationMethod(1);
        ByteProcessor targetMask = new ByteProcessor(width, height);
        targetMask.setInterpolationMethod(1);
        Loader loader = patches.get(0).getProject().getLoader();
        for (Patch patch : patches) {
            ByteProcessor alpha;
            MipMapImage mipMap = loader.fetchImage(patch, scale);
            BufferedImage bi = new BufferedImage(mipMap.image.getWidth(null), mipMap.image.getHeight(null), 2);
            Graphics2D g2d = bi.createGraphics();
            g2d.drawImage(mipMap.image, 0, 0, null);
            g2d.dispose();
            int[] pix = ExportARGB.extractARGBIntArray(bi);
            bi.flush();
            ColorProcessor rgb = new ColorProcessor(bi.getWidth(), bi.getHeight(), pix);
            if (patch.hasAlphaChannel()) {
                byte[] a = new byte[pix.length];
                for (int i = 0; i < a.length; ++i) {
                    a[i] = (byte)((pix[i] & 0xFF000000) >> 24);
                }
                alpha = new ByteProcessor(bi.getWidth(), bi.getHeight(), a);
            } else {
                alpha = new ByteProcessor(bi.getWidth(), bi.getHeight());
                Arrays.fill((byte[])alpha.getPixels(), (byte)-1);
            }
            AffineTransform atc = new AffineTransform();
            atc.scale(scale, scale);
            atc.translate(-roi.x, -roi.y);
            AffineTransform at = new AffineTransform();
            at.preConcatenate(atc);
            at.concatenate(patch.getAffineTransform());
            at.scale(mipMap.scaleX, mipMap.scaleY);
            AffineModel2D aff = new AffineModel2D();
            aff.set(at);
            CoordinateTransformMesh mesh = new CoordinateTransformMesh((CoordinateTransform)aff, patch.getMeshResolution(), (double)bi.getWidth(), (double)bi.getHeight());
            TransformMeshMappingWithMasks mapping = new TransformMeshMappingWithMasks((TransformMesh)mesh);
            alpha.setInterpolationMethod(0);
            rgb.setInterpolationMethod(1);
            mapping.map(rgb, alpha, target, targetMask);
        }
        return new Pair((Object)target, (Object)targetMask);
    }

    public static final Pair<ColorProcessor, ByteProcessor> makeFlatImageARGBFromOriginals(List<Patch> patches, Rectangle roi, double backgroundValue, double scale) {
        ColorProcessor target = new ColorProcessor((int)((double)roi.width * scale), (int)((double)roi.height * scale));
        target.setInterpolationMethod(1);
        ByteProcessor targetMask = new ByteProcessor(target.getWidth(), target.getHeight());
        targetMask.setInterpolationMethod(1);
        for (Patch patch : patches) {
            ByteProcessor alpha;
            Patch.PatchImage pai = patch.createTransformedImage();
            ColorProcessor fp = (ColorProcessor)pai.target.convertToRGB();
            System.out.println("IMAGE:" + patch.getTitle());
            System.out.println("mask: " + pai.mask);
            System.out.println("outside: " + pai.outside);
            if (null == pai.mask) {
                if (null == pai.outside) {
                    alpha = new ByteProcessor(fp.getWidth(), fp.getHeight());
                    Arrays.fill((byte[])alpha.getPixels(), (byte)-1);
                } else {
                    alpha = pai.outside;
                }
            } else {
                alpha = pai.mask;
            }
            AffineTransform atc = new AffineTransform();
            atc.scale(scale, scale);
            atc.translate(-roi.x, -roi.y);
            AffineTransform at = new AffineTransform();
            at.preConcatenate(atc);
            at.concatenate(patch.getAffineTransform());
            AffineModel2D aff = new AffineModel2D();
            aff.set(at);
            CoordinateTransformMesh mesh = new CoordinateTransformMesh((CoordinateTransform)aff, patch.getMeshResolution(), (double)fp.getWidth(), (double)fp.getHeight());
            TransformMeshMappingWithMasks mapping = new TransformMeshMappingWithMasks((TransformMesh)mesh);
            fp.setInterpolationMethod(1);
            alpha.setInterpolationMethod(1);
            mapping.map(fp, alpha, target, targetMask);
        }
        return new Pair((Object)target, (Object)targetMask);
    }
}

