/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.intensity;

import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ini.trakem2.Project;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import mpicbg.ij.TransformMeshMapping;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.CoordinateTransformList;
import mpicbg.models.CoordinateTransformMesh;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TransformMesh;
import mpicbg.trakem2.transform.TransformMeshMappingWithMasks;
import mpicbg.trakem2.util.Downsampler;

public class Render {
    private Render() {
    }

    public static final BufferedImage createARGBImage(int[] pixels, int width, int height) {
        assert (pixels.length == width * height) : "The number of pixels is not equal to width * height.";
        BufferedImage image = new BufferedImage(width, height, 2);
        WritableRaster raster = image.getRaster();
        raster.setDataElements(0, 0, width, height, pixels);
        return image;
    }

    static final void saveImage(BufferedImage image, String path, String format) throws IOException {
        ImageIO.write((RenderedImage)image, format, new File(path));
    }

    protected static final double sampleAverageScale(CoordinateTransform ct, int width, int height, double dx) {
        ArrayList<PointMatch> samples = new ArrayList<PointMatch>();
        for (double y = 0.0; y < (double)height; y += dx) {
            for (double x = 0.0; x < (double)width; x += dx) {
                Point p = new Point(new double[]{x, y});
                p.apply(ct);
                samples.add(new PointMatch(p, p));
            }
        }
        SimilarityModel2D model = new SimilarityModel2D();
        try {
            model.fit(samples);
        }
        catch (NotEnoughDataPointsException e) {
            e.printStackTrace(System.err);
            return 1.0;
        }
        double[] data = new double[6];
        model.toArray(data);
        return Math.sqrt(data[0] * data[0] + data[1] * data[1]);
    }

    protected static final int bestMipmapLevel(double scale) {
        int invScale = (int)(1.0 / scale);
        int scaleLevel = 0;
        while (invScale > 1) {
            invScale >>= 1;
            ++scaleLevel;
        }
        return scaleLevel;
    }

    protected static final AffineModel2D createScaleLevelTransform(int scaleLevel) {
        AffineModel2D a = new AffineModel2D();
        int scale = 1 << scaleLevel;
        double t = (double)(scale - 1) * 0.5;
        a.set((double)scale, 0.0, 0.0, (double)scale, t, t);
        return a;
    }

    public static final void render(Patch patch, int coefficientsWidth, int coefficientsHeight, FloatProcessor targetImage, FloatProcessor targetWeight, ColorProcessor targetCoefficients, double x, double y, double scale) {
        int i;
        ByteProcessor bpMaskTarget;
        ByteProcessor bpMaskMipmap;
        CoordinateTransformList ctl = new CoordinateTransformList();
        ctl.add((CoordinateTransform)patch.getFullCoordinateTransform());
        AffineModel2D affineScale = new AffineModel2D();
        affineScale.set(scale, 0.0, 0.0, scale, -x * scale, -y * scale);
        ctl.add((CoordinateTransform)affineScale);
        int width = patch.getOWidth();
        int height = patch.getOHeight();
        double s = Render.sampleAverageScale((CoordinateTransform)ctl, width, height, width / patch.getMeshResolution());
        int mipmapLevel = Render.bestMipmapLevel(s);
        ImageProcessor ipMipmap = Downsampler.downsampleImageProcessor((ImageProcessor)patch.getImageProcessor(), (int)mipmapLevel);
        ImageProcessor tp = ipMipmap.createProcessor(targetImage.getWidth(), targetImage.getHeight());
        ByteProcessor bpMask = patch.getAlphaMask();
        if (bpMask == null) {
            bpMaskMipmap = null;
            bpMaskTarget = null;
        } else {
            bpMaskMipmap = bpMask == null ? null : Downsampler.downsampleByteProcessor((ByteProcessor)bpMask, (int)mipmapLevel);
            bpMaskTarget = new ByteProcessor(tp.getWidth(), tp.getHeight());
        }
        ColorProcessor cp = new ColorProcessor(ipMipmap.getWidth(), ipMipmap.getHeight());
        int w = cp.getWidth();
        int h = cp.getHeight();
        for (int yi = 0; yi < h; ++yi) {
            int yc = yi * coefficientsHeight / h;
            int ic = yc * coefficientsWidth;
            int iyi = yi * w;
            for (int xi = 0; xi < w; ++xi) {
                cp.set(iyi + xi, ic + xi * coefficientsWidth / w + 1);
            }
        }
        CoordinateTransformList ctlMipmap = new CoordinateTransformList();
        ctlMipmap.add((CoordinateTransform)Render.createScaleLevelTransform(mipmapLevel));
        ctlMipmap.add((CoordinateTransform)ctl);
        CoordinateTransformMesh mesh = new CoordinateTransformMesh((CoordinateTransform)ctlMipmap, patch.getMeshResolution(), (double)ipMipmap.getWidth(), (double)ipMipmap.getHeight());
        TransformMeshMappingWithMasks.ImageProcessorWithMasks source = new TransformMeshMappingWithMasks.ImageProcessorWithMasks(ipMipmap, (ImageProcessor)bpMaskMipmap, null);
        TransformMeshMappingWithMasks.ImageProcessorWithMasks target = new TransformMeshMappingWithMasks.ImageProcessorWithMasks(tp, (ImageProcessor)bpMaskTarget, null);
        TransformMeshMappingWithMasks mapping = new TransformMeshMappingWithMasks((TransformMesh)mesh);
        mapping.mapInterpolated(source, target, 1);
        TransformMeshMapping coefficientsMapMapping = new TransformMeshMapping((TransformMesh)mesh);
        coefficientsMapMapping.map((ImageProcessor)cp, (ImageProcessor)targetCoefficients, 1);
        byte[] alphaPixels = bpMaskTarget != null ? (byte[])bpMaskTarget.getPixels() : (byte[])target.outside.getPixels();
        double min = patch.getMin();
        double max = patch.getMax();
        double a = 1.0 / (max - min);
        double b = 0.00392156862745098;
        for (i = 0; i < alphaPixels.length; ++i) {
            targetImage.setf(i, (float)(((double)tp.getf(i) - min) * a));
        }
        for (i = 0; i < alphaPixels.length; ++i) {
            targetWeight.setf(i, (float)((double)(alphaPixels[i] & 0xFF) * 0.00392156862745098));
        }
    }

    public static final void main(String ... args) {
        new ImageJ();
        double scale = 0.05;
        int numCoefficients = 4;
        Project project = Project.openFSProject("/home/saalfeld/tmp/bock-lens-correction/subproject.xml", false);
        Layer layer = project.getRootLayerSet().getLayer(0);
        ArrayList<Displayable> patches = layer.getDisplayables(Patch.class);
        Patch patch1 = (Patch)patches.get(0);
        Patch patch2 = (Patch)patches.get(2);
        Rectangle box = patch1.getBoundingBox().intersection(patch2.getBoundingBox());
        int w = (int)((double)box.width * 0.05 + 0.5);
        int h = (int)((double)box.height * 0.05 + 0.5);
        FloatProcessor pixels1 = new FloatProcessor(w, h);
        FloatProcessor weights1 = new FloatProcessor(w, h);
        ColorProcessor coefficients1 = new ColorProcessor(w, h);
        FloatProcessor pixels2 = new FloatProcessor(w, h);
        FloatProcessor weights2 = new FloatProcessor(w, h);
        ColorProcessor coefficients2 = new ColorProcessor(w, h);
        Render.render(patch1, 4, 4, pixels1, weights1, coefficients1, box.x, box.y, 0.05);
        Render.render(patch2, 4, 4, pixels2, weights2, coefficients2, box.x, box.y, 0.05);
        ImageStack stack = new ImageStack(w, h);
        stack.addSlice((ImageProcessor)pixels1);
        stack.addSlice((ImageProcessor)pixels2);
        stack.addSlice((ImageProcessor)weights1);
        stack.addSlice((ImageProcessor)weights2);
        stack.addSlice((ImageProcessor)coefficients1.convertToFloatProcessor());
        stack.addSlice((ImageProcessor)coefficients2.convertToFloatProcessor());
        new ImagePlus("", stack).show();
    }
}

