/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.PrairieMetadata;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Power;
import ome.units.quantity.Time;
import ome.units.unit.Unit;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PrimitiveNumber;
import ome.xml.model.primitives.Timestamp;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PrairieReader
extends FormatReader {
    public static final String[] CFG_SUFFIX = new String[]{"cfg"};
    public static final String[] ENV_SUFFIX = new String[]{"env"};
    public static final String[] XML_SUFFIX = new String[]{"xml"};
    public static final String[] PRAIRIE_SUFFIXES = new String[]{"cfg", "env", "xml"};
    private static final int PRAIRIE_TAG_1 = 33628;
    private static final int PRAIRIE_TAG_2 = 33629;
    private static final int PRAIRIE_TAG_3 = 33630;
    private static final String DATE_FORMAT = "MM/dd/yyyy h:mm:ss a";
    private TiffReader tiff;
    private String xmlFile;
    private String cfgFile;
    private String envFile;
    private PrairieMetadata meta;
    private ArrayList<PrairieMetadata.Sequence> sequences;
    private int[] channels;
    private boolean[] framesAreTime;
    private boolean singleTiffMode;

    public PrairieReader() {
        super("Prairie TIFF", new String[]{"tif", "tiff", "cfg", "env", "xml"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .xml file, one .cfg file, and one or more .tif/.tiff files";
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public boolean isThisType(String name, boolean open) {
        if (!open) {
            return false;
        }
        Location file = new Location(name).getAbsoluteFile();
        Location parent = file.getParentFile();
        String prefix = file.getName();
        if (prefix.indexOf(46) != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        if (PrairieReader.checkSuffix((String)name, (String[])CFG_SUFFIX)) {
            if (prefix.lastIndexOf("Config") == -1) {
                return false;
            }
            prefix = prefix.substring(0, prefix.lastIndexOf("Config"));
        }
        Location xml = new Location(parent, prefix + ".xml");
        while (!xml.exists() && prefix.indexOf(95) != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("_"));
            xml = new Location(parent, prefix + ".xml");
        }
        boolean validXML = false;
        try (RandomAccessInputStream xmlStream = new RandomAccessInputStream(xml.getAbsolutePath());){
            validXML = this.isThisType(xmlStream);
        }
        catch (IOException e) {
            LOGGER.trace("Failed to check XML file's type", (Throwable)e);
        }
        return xml.exists() && super.isThisType(name, false) && validXML;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = (int)Math.min(0x100020L, stream.length());
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)blockLen, (boolean)false)) {
            return false;
        }
        String s = stream.readString(blockLen);
        if (s.indexOf("xml") != -1 && s.indexOf("<PV") != -1) {
            return true;
        }
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String software = null;
        try {
            software = ifd.getIFDStringValue(305);
        }
        catch (FormatException exc) {
            return false;
        }
        if (software == null) {
            return false;
        }
        if (software.indexOf("Prairie") < 0) {
            return false;
        }
        return ifd.containsKey((Object)33628) && ifd.containsKey((Object)33629) && ifd.containsKey((Object)33630);
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (this.singleTiffMode) {
            return this.tiff.getSeriesUsedFiles(noPixels);
        }
        ArrayList<String> usedFiles = new ArrayList<String>();
        if (this.xmlFile != null) {
            usedFiles.add(this.xmlFile);
        }
        if (this.cfgFile != null) {
            usedFiles.add(this.cfgFile);
        }
        if (this.envFile != null) {
            usedFiles.add(this.envFile);
        }
        if (!noPixels) {
            int s = this.getSeries();
            for (int t = 0; t < this.getSizeT(); ++t) {
                PrairieMetadata.Sequence sequence = this.sequence(t, s);
                for (int z = 0; z < this.getSizeZ(); ++z) {
                    int index = this.frameIndex(sequence, z, t, s);
                    PrairieMetadata.Frame frame = sequence.getFrame(index);
                    if (frame == null) {
                        this.warnFrame(sequence, index);
                        continue;
                    }
                    for (int c = 0; c < this.getSizeC(); ++c) {
                        int channel = this.channels[c];
                        PrairieMetadata.PFile file = frame.getFile(channel);
                        if (file == null) {
                            this.warnFile(sequence, index, channel);
                            continue;
                        }
                        String filename = file.getFilename();
                        if (filename == null) {
                            this.warnFilename(sequence, index, channel);
                            continue;
                        }
                        usedFiles.add(this.getPath(file));
                    }
                }
            }
        }
        return usedFiles.toArray(new String[usedFiles.size()]);
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        return this.tiff.getOptimalTileWidth();
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        return this.tiff.getOptimalTileHeight();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int index;
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        if (this.singleTiffMode) {
            return this.tiff.openBytes(no, buf, x, y, w, h);
        }
        int[] zct = this.getZCTCoords(no);
        int z = zct[0];
        int c = zct[1];
        int t = zct[2];
        PrairieMetadata.Sequence sequence = this.sequence(t, this.getSeries());
        PrairieMetadata.Frame frame = sequence.getFrame(index = this.frameIndex(sequence, z, t, this.getSeries()));
        if (frame == null) {
            this.warnFrame(sequence, index);
            return this.blank(buf);
        }
        int channel = this.channels[c];
        PrairieMetadata.PFile file = frame.getFile(channel);
        if (file == null) {
            this.warnFile(sequence, index, channel);
            return this.blank(buf);
        }
        this.tiff.setId(this.getPath(file));
        return this.tiff.openBytes(file.getPage().intValue(), buf, x, y, w, h);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiff != null) {
            this.tiff.close(fileOnly);
        }
        if (!fileOnly) {
            this.envFile = null;
            this.cfgFile = null;
            this.xmlFile = null;
            this.tiff = null;
            this.meta = null;
            this.sequences = null;
            this.channels = null;
            this.framesAreTime = null;
            this.singleTiffMode = false;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.tiff = new TiffReader();
        if (PrairieReader.checkSuffix((String)id, (String[])XML_SUFFIX)) {
            this.xmlFile = new Location(id).getAbsolutePath();
            this.findMetadataFiles();
        } else if (PrairieReader.checkSuffix((String)id, (String[])CFG_SUFFIX)) {
            this.cfgFile = new Location(id).getAbsolutePath();
            this.findMetadataFiles();
        } else if (PrairieReader.checkSuffix((String)id, (String[])ENV_SUFFIX)) {
            this.envFile = new Location(id).getAbsolutePath();
            this.findMetadataFiles();
        } else if (this.isGroupFiles()) {
            this.findMetadataFiles();
        } else {
            this.singleTiffMode = true;
            this.tiff.setId(id);
            return;
        }
        this.currentId = this.xmlFile;
        this.parsePrairieMetadata();
        this.populateCoreMetadata();
        this.populateOriginalMetadata();
        this.populateOMEMetadata();
    }

    private void findMetadataFiles() {
        Location env;
        Location cfg;
        Location xml;
        LOGGER.info("Finding metadata files");
        if (this.xmlFile == null && (xml = this.find(XML_SUFFIX)) != null) {
            this.xmlFile = xml.getAbsolutePath();
        }
        if (this.cfgFile == null && (cfg = this.find(CFG_SUFFIX)) != null) {
            this.cfgFile = cfg.getAbsolutePath();
        }
        if (this.envFile == null && (env = this.find(ENV_SUFFIX)) != null) {
            this.envFile = env.getAbsolutePath();
        }
    }

    private void parsePrairieMetadata() throws FormatException, IOException {
        LOGGER.info("Parsing Prairie metadata");
        Document xml = null;
        Document cfg = null;
        Document env = null;
        try {
            if (this.xmlFile != null) {
                xml = this.parseDOM(new Location(this.xmlFile));
            }
            if (this.cfgFile != null) {
                cfg = this.parseDOM(new Location(this.cfgFile));
            }
            if (this.envFile != null) {
                env = this.parseDOM(new Location(this.envFile));
            }
        }
        catch (ParserConfigurationException exc) {
            throw new FormatException((Throwable)exc);
        }
        catch (SAXException exc) {
            throw new FormatException((Throwable)exc);
        }
        this.meta = new PrairieMetadata(xml, cfg, env);
        this.sequences = this.meta.getSequences();
        this.channels = this.meta.getActiveChannels();
        if (this.channels == null || this.channels.length == 0) {
            throw new FormatException("No active channels found");
        }
    }

    private void populateCoreMetadata() throws FormatException, IOException {
        LOGGER.info("Populating core metadata");
        int sequenceCount = this.sequences.size();
        int sizeT = this.computeSizeT(sequenceCount);
        int seriesCount = sequenceCount / sizeT;
        Integer bitDepth = this.meta.getBitDepth();
        int bpp = bitDepth == null ? -1 : bitDepth;
        this.core.clear();
        this.framesAreTime = new boolean[seriesCount];
        for (int s = 0; s < seriesCount; ++s) {
            PrairieMetadata.PFile file;
            PrairieMetadata.Sequence sequence = this.sequence(0, s, seriesCount);
            PrairieMetadata.Frame frame = sequence.getFirstFrame();
            PrairieMetadata.PFile pFile = file = frame == null ? null : frame.getFirstFile();
            if (frame == null || file == null) {
                throw new FormatException("No metadata for series #" + s);
            }
            if (s == 0) {
                this.tiff.setId(this.getPath(file));
                if (bpp <= 0) {
                    bpp = this.tiff.getBitsPerPixel();
                }
            }
            Integer linesPerFrame = frame.getLinesPerFrame();
            Integer pixelsPerLine = frame.getPixelsPerLine();
            int indexCount = sequence.getIndexCount();
            int sizeX = pixelsPerLine == null ? this.tiff.getSizeX() : pixelsPerLine.intValue();
            int sizeY = linesPerFrame == null ? this.tiff.getSizeY() : linesPerFrame.intValue();
            this.framesAreTime[s] = sequence.isTimeSeries() && sizeT == 1;
            CoreMetadata cm = new CoreMetadata();
            cm.sizeX = sizeX;
            cm.sizeY = sizeY;
            cm.sizeZ = this.framesAreTime[s] ? 1 : indexCount;
            cm.sizeC = this.channels.length;
            cm.sizeT = this.framesAreTime[s] ? indexCount : sizeT;
            cm.pixelType = this.tiff.getPixelType();
            cm.bitsPerPixel = bpp;
            cm.imageCount = cm.sizeZ * cm.sizeC * cm.sizeT;
            cm.dimensionOrder = "XYCZT";
            cm.orderCertain = true;
            cm.rgb = false;
            cm.littleEndian = this.tiff.isLittleEndian();
            cm.interleaved = false;
            cm.indexed = this.tiff.isIndexed();
            cm.falseColor = false;
            this.core.add(cm);
        }
    }

    private void populateOriginalMetadata() {
        boolean minimumMetadata = this.isMinimumMetadata();
        if (minimumMetadata) {
            return;
        }
        this.addGlobalMeta("cycleCount", this.meta.getCycleCount());
        this.addGlobalMeta("date", this.meta.getDate());
        this.addGlobalMeta("waitTime", this.meta.getWaitTime());
        this.addGlobalMeta("sequenceCount", this.sequences.size());
        PrairieMetadata.ValueTable config = this.meta.getConfig();
        for (String key : config.keySet()) {
            this.addGlobalMeta(key, ((PrairieMetadata.Value)config.get(key)).toString());
        }
        this.addGlobalMeta("meta", this.meta);
        int seriesCount = this.getSeriesCount();
        for (int s = 0; s < seriesCount; ++s) {
            this.setSeries(s);
            PrairieMetadata.Sequence sequence = this.sequence(s);
            this.addSeriesMeta("cycle", sequence.getCycle());
            this.addSeriesMeta("indexCount", sequence.getIndexCount());
            this.addSeriesMeta("type", sequence.getType());
        }
        this.setSeries(0);
    }

    private void populateOMEMetadata() throws FormatException {
        LOGGER.info("Populating OME metadata");
        boolean minimumMetadata = this.isMinimumMetadata();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (!minimumMetadata ? 1 : 0) != 0);
        String date = DateTools.formatDate(this.meta.getDate(), DATE_FORMAT);
        Timestamp acquisitionDate = Timestamp.valueOf((String)date);
        int seriesCount = this.getSeriesCount();
        for (int s = 0; s < seriesCount; ++s) {
            this.setSeries(s);
            if (date == null) continue;
            store.setImageAcquisitionDate(acquisitionDate, s);
        }
        if (minimumMetadata) {
            return;
        }
        String instrumentID = MetadataTools.createLSID((String)"Instrument", (int[])new int[]{0});
        store.setInstrumentID(instrumentID, 0);
        Double laserPower = this.meta.getLaserPower();
        if (laserPower != null) {
            String laserID = MetadataTools.createLSID((String)"LightSource", (int[])new int[]{0, 0});
            store.setLaserID(laserID, 0, 0);
            store.setLaserPower(new Power((Number)laserPower, UNITS.MILLIWATT), 0, 0);
        }
        String objectiveID = null;
        for (int s = 0; s < seriesCount; ++s) {
            Double waitTime;
            PositiveFloat physicalSizeY;
            this.setSeries(s);
            PrairieMetadata.Sequence sequence = this.sequence(s);
            PrairieMetadata.Frame firstFrame = sequence.getFirstFrame();
            store.setImageInstrumentRef(instrumentID, s);
            PositiveFloat physicalSizeX = this.pf(firstFrame.getMicronsPerPixelX(), "PhysicalSizeX");
            if (physicalSizeX != null) {
                store.setPixelsPhysicalSizeX(FormatTools.createLength((PrimitiveNumber)physicalSizeX, (Unit)UNITS.MICROMETER), s);
            }
            if ((physicalSizeY = this.pf(firstFrame.getMicronsPerPixelY(), "PhysicalSizeY")) != null) {
                store.setPixelsPhysicalSizeY(FormatTools.createLength((PrimitiveNumber)physicalSizeY, (Unit)UNITS.MICROMETER), s);
            }
            if ((waitTime = this.meta.getWaitTime()) != null) {
                store.setPixelsTimeIncrement(new Time((Number)waitTime, UNITS.SECOND), s);
            }
            String[] detectorIDs = new String[this.channels.length];
            for (int c = 0; c < this.channels.length; ++c) {
                Double gain;
                String channelName;
                int channel = this.channels[c];
                PrairieMetadata.PFile file = firstFrame.getFile(channel);
                String string = channelName = file == null ? null : file.getChannelName();
                if (channelName != null) {
                    store.setChannelName(channelName, s, c);
                }
                if (file != null) {
                    Double waveMin = file.getWavelengthMin();
                    Double waveMax = file.getWavelengthMax();
                    if (waveMin != null && waveMax != null) {
                        double waveAvg = (waveMin + waveMax) / 2.0;
                        Length wavelength = FormatTools.getEmissionWavelength((Double)waveAvg);
                        store.setChannelEmissionWavelength(wavelength, s, c);
                    }
                }
                if (detectorIDs[c] == null) {
                    detectorIDs[c] = MetadataTools.createLSID((String)"Detector", (int[])new int[]{0, c});
                    store.setDetectorID(detectorIDs[c], 0, c);
                    store.setDetectorType(MetadataTools.getDetectorType((String)"Other"), 0, c);
                    Double zoom = firstFrame.getOpticalZoom();
                    if (zoom != null) {
                        store.setDetectorZoom(zoom, 0, c);
                    }
                }
                store.setDetectorSettingsID(detectorIDs[c], s, c);
                Double offset = firstFrame.getOffset(c);
                if (offset != null) {
                    store.setDetectorSettingsOffset(offset, s, c);
                }
                if ((gain = firstFrame.getGain(c)) == null) continue;
                store.setDetectorSettingsGain(gain, s, c);
            }
            if (objectiveID == null) {
                objectiveID = MetadataTools.createLSID((String)"Objective", (int[])new int[]{0, 0});
                store.setObjectiveID(objectiveID, 0, 0);
                store.setObjectiveCorrection(MetadataTools.getCorrection((String)"Other"), 0, 0);
                Double magnification = firstFrame.getMagnification();
                if (magnification != null) {
                    store.setObjectiveNominalMagnification(magnification, 0, 0);
                }
                String objectiveManufacturer = firstFrame.getObjectiveManufacturer();
                store.setObjectiveManufacturer(objectiveManufacturer, 0, 0);
                String immersion = firstFrame.getImmersion();
                store.setObjectiveImmersion(MetadataTools.getImmersion((String)immersion), 0, 0);
                Double lensNA = firstFrame.getObjectiveLensNA();
                if (lensNA != null) {
                    store.setObjectiveLensNA(lensNA, 0, 0);
                }
                String microscopeModel = firstFrame.getImagingDevice();
                store.setMicroscopeModel(microscopeModel, 0);
            }
            store.setObjectiveSettingsID(objectiveID, s);
            for (int t = 0; t < this.getSizeT(); ++t) {
                PrairieMetadata.Sequence tSequence = this.sequence(t, s);
                for (int z = 0; z < this.getSizeZ(); ++z) {
                    int index = this.frameIndex(tSequence, z, t, s);
                    PrairieMetadata.Frame zFrame = tSequence.getFrame(index);
                    if (zFrame == null) {
                        this.warnFrame(sequence, index);
                        continue;
                    }
                    Length posX = zFrame.getPositionX();
                    Length posY = zFrame.getPositionY();
                    Length posZ = zFrame.getPositionZ();
                    Double deltaT = zFrame.getRelativeTime();
                    for (int c = 0; c < this.getSizeC(); ++c) {
                        int i = this.getIndex(z, c, t);
                        if (posX != null) {
                            store.setPlanePositionX(posX, s, i);
                        }
                        if (posY != null) {
                            store.setPlanePositionY(posY, s, i);
                        }
                        if (posZ != null) {
                            store.setPlanePositionZ(posZ, s, i);
                        }
                        if (deltaT == null) continue;
                        store.setPlaneDeltaT(new Time((Number)deltaT, UNITS.SECOND), s, i);
                    }
                }
            }
        }
        this.setSeries(0);
    }

    private boolean isMinimumMetadata() {
        return this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM;
    }

    private Document parseDOM(Location file) throws ParserConfigurationException, SAXException, IOException {
        if (file == null) {
            return null;
        }
        byte[] buf = new byte[(int)file.length()];
        try (RandomAccessInputStream is = new RandomAccessInputStream(file.getAbsolutePath());){
            is.readFully(buf);
        }
        String xml = XMLTools.sanitizeXML(new String(buf, "UTF-8"));
        return XMLTools.parseDOM(xml);
    }

    private void warnFrame(PrairieMetadata.Sequence sequence, int index) {
        LOGGER.warn("No Frame at cycle #{}, index #{}", (Object)sequence.getCycle(), (Object)index);
    }

    private void warnFile(PrairieMetadata.Sequence sequence, int index, int channel) {
        LOGGER.warn("No File at cycle #" + sequence.getCycle() + ", index #{}, channel #{}", (Object)index, (Object)channel);
    }

    private void warnFilename(PrairieMetadata.Sequence sequence, int index, int channel) {
        LOGGER.warn("File at cycle #" + sequence.getCycle() + ", index #{}, channel #{} has null filename", (Object)index, (Object)channel);
    }

    private String getPath(PrairieMetadata.PFile file) {
        Location f = new Location(new Location(this.xmlFile).getParent(), file.getFilename());
        return f.getAbsolutePath();
    }

    private byte[] blank(byte[] buf) {
        Arrays.fill(buf, this.getFillColor());
        return buf;
    }

    private PositiveFloat pf(Double value, String name) {
        if (value == null) {
            return null;
        }
        try {
            return new PositiveFloat(value);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Expected positive value for {}; got {}", (Object)name, (Object)value);
            return null;
        }
    }

    private Location find(String[] suffix) {
        String[] listing;
        Location file = new Location(this.currentId).getAbsoluteFile();
        Location parent = file.getParentFile();
        for (String name : listing = parent.list()) {
            if (!PrairieReader.checkSuffix((String)name, (String[])suffix)) continue;
            return new Location(parent, name);
        }
        return null;
    }

    private int computeSizeT(int sequenceCount) {
        for (int sizeP = 1; sizeP <= sequenceCount; ++sizeP) {
            int sizeT;
            if (sequenceCount % sizeP != 0 || !this.positionsMatch(sizeT = sequenceCount / sizeP, sizeP)) continue;
            return sizeT;
        }
        return 1;
    }

    private boolean positionsMatch(int sizeT, int sizeP) {
        block0: for (int p = 0; p < sizeP; ++p) {
            PrairieMetadata.Sequence initialSequence = this.sequence(0, p, sizeP);
            int indexMin = initialSequence.getIndexMin();
            int indexCount = initialSequence.getIndexCount();
            for (int z = 0; z < indexCount; ++z) {
                int index = z + indexMin;
                PrairieMetadata.Frame initialFrame = initialSequence.getFrame(index);
                if (initialFrame == null) {
                    this.warnFrame(initialSequence, index);
                    continue block0;
                }
                Length xInitial = initialFrame.getPositionX();
                Length yInitial = initialFrame.getPositionY();
                Length zInitial = initialFrame.getPositionZ();
                for (int t = 1; t < sizeT; ++t) {
                    PrairieMetadata.Sequence sequence = this.sequence(t, p, sizeP);
                    PrairieMetadata.Frame frame = sequence.getFrame(index);
                    if (frame == null) {
                        this.warnFrame(sequence, index);
                        continue;
                    }
                    Length xPos = frame.getPositionX();
                    Length yPos = frame.getPositionY();
                    Length zPos = frame.getPositionZ();
                    if (PrairieReader.equal(xPos, xInitial) && PrairieReader.equal(yPos, yInitial) && PrairieReader.equal(zPos, zInitial)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private PrairieMetadata.Sequence sequence(int s) {
        return this.sequence(0, s);
    }

    private PrairieMetadata.Sequence sequence(int t, int s) {
        int actualT = this.framesAreTime[s] ? 0 : t;
        return this.sequence(actualT, s, this.getSeriesCount());
    }

    private PrairieMetadata.Sequence sequence(int t, int p, int sizeP) {
        return this.sequences.get(sizeP * t + p);
    }

    private int frameIndex(PrairieMetadata.Sequence sequence, int z, int t, int s) {
        return (this.framesAreTime[s] ? t : z) + sequence.getIndexMin();
    }

    private static boolean equal(Length xPos, Length xInitial) {
        if (xPos == null && xInitial == null) {
            return true;
        }
        if (xPos == null) {
            return false;
        }
        return xPos.equals((Object)xInitial);
    }
}

