/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import java.io.File;
import java.io.FileFilter;

public class NumberFilter
implements FileFilter {
    private final String pre;
    private final String post;

    public NumberFilter(String pre, String post) {
        this.pre = pre;
        this.post = post;
    }

    public Integer getNumber(String name) {
        if (!name.startsWith(this.pre) || !name.endsWith(this.post)) {
            return null;
        }
        int ndx = this.pre.length();
        int end = name.length() - this.post.length();
        try {
            return new Integer(name.substring(ndx, end));
        }
        catch (IndexOutOfBoundsException | NumberFormatException exc) {
            return null;
        }
    }

    public boolean accept(String name) {
        return this.getNumber(name) != null;
    }

    @Override
    public boolean accept(File pathname) {
        return this.accept(pathname.getName());
    }
}

