/*
 * Decompiled with CFR 0.152.
 */
package io.scif.codec;

public class BitBuffer {
    private static final int[] BACK_MASK = new int[]{0, 1, 3, 7, 15, 31, 63, 127};
    private static final int[] FRONT_MASK = new int[]{0, 128, 192, 224, 240, 248, 252, 254};
    private final byte[] byteBuffer;
    private int currentByte;
    private int currentBit;
    private final int eofByte;
    private boolean eofFlag;

    public BitBuffer(byte[] byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.currentByte = 0;
        this.currentBit = 0;
        this.eofByte = byteBuffer.length;
    }

    public void skipBits(long bits) {
        if (bits < 0L) {
            throw new IllegalArgumentException("Bits to skip may not be negative");
        }
        if ((long)this.eofByte * 8L < (long)this.currentByte * 8L + (long)this.currentBit + bits) {
            this.eofFlag = true;
            this.currentByte = this.eofByte;
            this.currentBit = 0;
            return;
        }
        int skipBytes = (int)(bits / 8L);
        int skipBits = (int)(bits % 8L);
        this.currentByte += skipBytes;
        this.currentBit += skipBits;
        while (this.currentBit >= 8) {
            ++this.currentByte;
            this.currentBit -= 8;
        }
    }

    public int getBits(int bitsToRead) {
        if (bitsToRead < 0) {
            throw new IllegalArgumentException("Bits to read may not be negative");
        }
        if (bitsToRead == 0) {
            return 0;
        }
        if (this.eofFlag) {
            return -1;
        }
        int toStore = 0;
        while (bitsToRead != 0 && !this.eofFlag) {
            int cb;
            if (this.currentBit < 0 || this.currentBit > 7) {
                throw new IllegalStateException("byte=" + this.currentByte + ", bit = " + this.currentBit);
            }
            int bitsLeft = 8 - this.currentBit;
            if (bitsToRead >= bitsLeft) {
                toStore <<= bitsLeft;
                bitsToRead -= bitsLeft;
                cb = this.byteBuffer[this.currentByte];
                if (this.currentBit == 0) {
                    toStore += cb & 0xFF;
                } else {
                    toStore += cb & BACK_MASK[bitsLeft];
                    this.currentBit = 0;
                }
                ++this.currentByte;
            } else {
                toStore <<= bitsToRead;
                cb = this.byteBuffer[this.currentByte] & 0xFF;
                toStore += (cb & 255 - FRONT_MASK[this.currentBit]) >> bitsLeft - bitsToRead;
                this.currentBit += bitsToRead;
                bitsToRead = 0;
            }
            if (this.currentByte != this.eofByte) continue;
            this.eofFlag = true;
            return toStore;
        }
        return toStore;
    }
}

