/*
 * Decompiled with CFR 0.152.
 */
package io.scif.codec;

public class ByteVector {
    private byte[] data;
    private int size;

    public ByteVector() {
        this.data = new byte[10];
        this.size = 0;
    }

    public ByteVector(int initialSize) {
        this.data = new byte[initialSize];
        this.size = 0;
    }

    public ByteVector(byte[] byteBuffer) {
        this.data = byteBuffer;
        this.size = 0;
    }

    public void add(byte x) {
        while (this.size >= this.data.length) {
            this.doubleCapacity();
        }
        this.data[this.size++] = x;
    }

    public int size() {
        return this.size;
    }

    public byte get(int index) {
        return this.data[index];
    }

    public void add(byte[] array) {
        this.add(array, 0, array.length);
    }

    public void add(byte[] array, int off, int len) {
        while (this.data.length < this.size + len) {
            this.doubleCapacity();
        }
        if (len == 1) {
            this.data[this.size] = array[off];
        } else if (len < 35) {
            for (int i = 0; i < len; ++i) {
                this.data[this.size + i] = array[off + i];
            }
        } else {
            System.arraycopy(array, off, this.data, this.size, len);
        }
        this.size += len;
    }

    void doubleCapacity() {
        byte[] tmp = new byte[this.data.length * 2 + 1];
        System.arraycopy(this.data, 0, tmp, 0, this.data.length);
        this.data = tmp;
    }

    public void clear() {
        this.size = 0;
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[this.size];
        System.arraycopy(this.data, 0, bytes, 0, this.size);
        return bytes;
    }
}

