/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.tiff;

import io.scif.FormatException;
import io.scif.SCIFIO;
import io.scif.codec.CodecOptions;
import io.scif.formats.tiff.IFD;
import io.scif.formats.tiff.IFDList;
import io.scif.formats.tiff.IFDType;
import io.scif.formats.tiff.PhotoInterp;
import io.scif.formats.tiff.TiffCompression;
import io.scif.formats.tiff.TiffIFDEntry;
import io.scif.formats.tiff.TiffParser;
import io.scif.formats.tiff.TiffRational;
import io.scif.util.FormatTools;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import org.scijava.AbstractContextual;
import org.scijava.Context;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.handle.DataHandles;
import org.scijava.io.location.BytesLocation;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;

public class TiffSaver
extends AbstractContextual {
    private final DataHandle<Location> out;
    private Location loc;
    private BytesLocation bytes;
    private boolean bigTiff = false;
    private boolean sequentialWrite = false;
    private CodecOptions options;
    private SCIFIO scifio;
    @Parameter
    private LogService log;
    @Parameter
    private DataHandleService dataHandleService;

    public TiffSaver(Context ctx, String filename) throws IOException {
        this(ctx, (Location)new FileLocation(filename));
    }

    public TiffSaver(Context ctx, Location loc) throws IOException {
        Objects.requireNonNull(loc);
        Objects.requireNonNull(ctx);
        this.setContext(ctx);
        this.loc = loc;
        this.out = (DataHandle)this.dataHandleService.create((Object)loc);
        this.scifio = new SCIFIO(ctx);
        this.log = this.scifio.log();
    }

    public TiffSaver(Context ctx, DataHandle<Location> out) {
        if (out == null) {
            throw new IllegalArgumentException("Output stream expected to be not-null");
        }
        this.out = out;
        this.loc = (Location)out.get();
        this.setContext(ctx);
        this.scifio = new SCIFIO(ctx);
        this.log = this.scifio.log();
    }

    public TiffSaver(DataHandle<Location> out, BytesLocation bytes) {
        this.setContext(new Context());
        if (out == null) {
            throw new IllegalArgumentException("Output stream expected to be not-null");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("Bytes expected to be not null");
        }
        this.out = out;
        this.bytes = bytes;
    }

    public void setWritingSequentially(boolean sequential) {
        this.sequentialWrite = sequential;
    }

    public DataHandle<Location> getStream() {
        return this.out;
    }

    public void setLittleEndian(boolean littleEndian) {
        this.out.setLittleEndian(littleEndian);
    }

    public void setBigTiff(boolean bigTiff) {
        this.bigTiff = bigTiff;
    }

    public boolean isLittleEndian() {
        return this.out.isLittleEndian();
    }

    public boolean isBigTiff() {
        return this.bigTiff;
    }

    public void setCodecOptions(CodecOptions options) {
        this.options = options;
    }

    public void writeHeader() throws IOException {
        this.out.seek(0L);
        if (this.isLittleEndian()) {
            this.out.writeByte(73);
            this.out.writeByte(73);
        } else {
            this.out.writeByte(77);
            this.out.writeByte(77);
        }
        if (this.bigTiff) {
            this.out.writeShort(43);
        } else {
            this.out.writeShort(42);
        }
        if (this.bigTiff) {
            this.out.writeShort(8);
            this.out.writeShort(0);
            this.out.writeLong(16L);
        } else {
            this.out.writeInt(8);
        }
    }

    public void writeImage(byte[][] buf, IFDList ifds, int pixelType) throws FormatException, IOException {
        if (ifds == null) {
            throw new FormatException("IFD cannot be null");
        }
        if (buf == null) {
            throw new FormatException("Image data cannot be null");
        }
        for (int i = 0; i < ifds.size(); ++i) {
            if (i >= buf.length) continue;
            this.writeImage(buf[i], (IFD)ifds.get(i), i, pixelType, i == ifds.size() - 1);
        }
    }

    public void writeImage(byte[] buf, IFD ifd, int no, int pixelType, boolean last) throws FormatException, IOException {
        if (ifd == null) {
            throw new FormatException("IFD cannot be null");
        }
        int w = (int)ifd.getImageWidth();
        int h = (int)ifd.getImageLength();
        this.writeImage(buf, ifd, no, pixelType, 0, 0, w, h, last);
    }

    public void writeImage(byte[] buf, IFD ifd, long planeIndex, int pixelType, int x, int y, int w, int h, boolean last) throws FormatException, IOException {
        this.writeImage(buf, ifd, planeIndex, pixelType, x, y, w, h, last, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeImage(byte[] buf, IFD ifd, long planeIndex, int pixelType, int x, int y, int w, int h, boolean last, Integer nChannels, boolean copyDirectly) throws FormatException, IOException {
        ByteArrayOutputStream[] stripBuf;
        int nStrips;
        int tileHeight;
        int tileWidth;
        TiffCompression compression;
        boolean interleaved;
        this.log.debug((Object)"Attempting to write image.");
        if (buf == null) {
            throw new FormatException("Image data cannot be null");
        }
        if (ifd == null) {
            throw new FormatException("IFD cannot be null");
        }
        TiffSaver tiffSaver = this;
        synchronized (tiffSaver) {
            int effectiveStrips;
            int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
            int blockSize = w * h * bytesPerPixel;
            if (nChannels == null) {
                nChannels = buf.length / (w * h * bytesPerPixel);
            }
            interleaved = ifd.getPlanarConfiguration() == 1;
            this.makeValidIFD(ifd, pixelType, nChannels);
            compression = ifd.getCompression();
            tileWidth = (int)ifd.getTileWidth();
            tileHeight = (int)ifd.getTileLength();
            int tilesPerRow = (int)ifd.getTilesPerRow();
            int rowsPerStrip = (int)ifd.getRowsPerStrip()[0];
            int stripSize = rowsPerStrip * tileWidth * bytesPerPixel;
            nStrips = (w + tileWidth - 1) / tileWidth * ((h + tileHeight - 1) / tileHeight);
            if (interleaved) {
                stripSize *= nChannels.intValue();
            } else {
                nStrips *= nChannels.intValue();
            }
            stripBuf = new ByteArrayOutputStream[nStrips];
            DataOutputStream[] stripOut = new DataOutputStream[nStrips];
            for (int strip = 0; strip < nStrips; ++strip) {
                stripBuf[strip] = new ByteArrayOutputStream(stripSize);
                stripOut[strip] = new DataOutputStream(stripBuf[strip]);
            }
            int[] bps = ifd.getBitsPerSample();
            int n = effectiveStrips = !interleaved ? nStrips / nChannels : nStrips;
            if (effectiveStrips == 1 && copyDirectly) {
                stripOut[0].write(buf);
            } else {
                for (int strip = 0; strip < effectiveStrips; ++strip) {
                    int xOffset = strip % tilesPerRow * tileWidth;
                    int yOffset = strip / tilesPerRow * tileHeight;
                    for (int row = 0; row < tileHeight; ++row) {
                        for (int col = 0; col < tileWidth; ++col) {
                            int ndx = ((row + yOffset) * w + col + xOffset) * bytesPerPixel;
                            for (int c = 0; c < nChannels; ++c) {
                                for (int n2 = 0; n2 < bps[c] / 8; ++n2) {
                                    int off;
                                    if (interleaved) {
                                        off = ndx * nChannels + c * bytesPerPixel + n2;
                                        if (row >= h || col >= w) {
                                            stripOut[strip].writeByte(0);
                                            continue;
                                        }
                                        stripOut[strip].writeByte(buf[off]);
                                        continue;
                                    }
                                    off = c * blockSize + ndx + n2;
                                    if (row >= h || col >= w) {
                                        stripOut[strip].writeByte(0);
                                        continue;
                                    }
                                    stripOut[c * (nStrips / nChannels) + strip].writeByte(buf[off]);
                                }
                            }
                        }
                    }
                }
            }
        }
        byte[][] strips = new byte[nStrips][];
        for (int strip = 0; strip < nStrips; ++strip) {
            strips[strip] = stripBuf[strip].toByteArray();
            this.scifio.tiff().difference(strips[strip], ifd);
            CodecOptions codecOptions = compression.getCompressionCodecOptions(ifd, this.options);
            codecOptions.height = tileHeight;
            codecOptions.width = tileWidth;
            codecOptions.channels = interleaved ? nChannels : 1;
            strips[strip] = compression.compress(this.scifio.codec(), strips[strip], codecOptions);
            if (!this.log.isDebug()) continue;
            this.log.debug((Object)String.format("Compressed strip %d/%d length %d", strip + 1, nStrips, strips[strip].length));
        }
        TiffSaver tiffSaver2 = this;
        synchronized (tiffSaver2) {
            this.writeImageIFD(ifd, planeIndex, strips, nChannels, last, x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeImageIFD(IFD ifd, long planeIndex, byte[][] strips, int nChannels, boolean last, int x, int y) throws FormatException, IOException {
        this.log.debug((Object)"Attempting to write image IFD.");
        int tilesPerRow = (int)ifd.getTilesPerRow();
        int tilesPerColumn = (int)ifd.getTilesPerColumn();
        boolean interleaved = ifd.getPlanarConfiguration() == 1;
        boolean isTiled = ifd.isTiled();
        if (!this.sequentialWrite) {
            DataHandle in = null;
            if (this.loc != null) {
                in = (DataHandle)this.dataHandleService.create((Object)this.loc);
            } else if (this.out != null) {
                in = (DataHandle)this.dataHandleService.create(this.out.get());
            } else if (this.bytes != null) {
                in = (DataHandle)this.dataHandleService.create((Object)this.bytes);
            } else {
                throw new IllegalArgumentException("Filename and bytes are null, cannot create new input stream!");
            }
            try {
                TiffParser parser = new TiffParser(this.getContext(), (DataHandle<Location>)in);
                long[] ifdOffsets = parser.getIFDOffsets();
                this.log.debug((Object)("IFD offsets: " + Arrays.toString(ifdOffsets)));
                if (planeIndex < (long)ifdOffsets.length) {
                    this.out.seek(ifdOffsets[(int)planeIndex]);
                    this.log.debug((Object)("Reading IFD from " + ifdOffsets[(int)planeIndex] + " in non-sequential write."));
                    ifd = parser.getIFD(ifdOffsets[(int)planeIndex]);
                }
            }
            finally {
                in.close();
            }
        }
        ArrayList<Long> byteCounts = new ArrayList<Long>();
        ArrayList<Long> offsets = new ArrayList<Long>();
        long totalTiles = tilesPerRow * tilesPerColumn;
        if (!interleaved) {
            totalTiles *= (long)nChannels;
        }
        if (ifd.containsKey(279) || ifd.containsKey(325)) {
            long[] ifdByteCounts;
            for (long stripByteCount : ifdByteCounts = isTiled ? ifd.getIFDLongArray(325) : ifd.getStripByteCounts()) {
                byteCounts.add(stripByteCount);
            }
        } else {
            while ((long)byteCounts.size() < totalTiles) {
                byteCounts.add(0L);
            }
        }
        int tileOrStripOffsetX = x / (int)ifd.getTileWidth();
        int tileOrStripOffsetY = y / (int)ifd.getTileLength();
        int firstOffset = tileOrStripOffsetY * tilesPerRow + tileOrStripOffsetX;
        if (ifd.containsKey(273) || ifd.containsKey(324)) {
            long[] ifdOffsets;
            for (long ifdOffset : ifdOffsets = isTiled ? ifd.getIFDLongArray(324) : ifd.getStripOffsets()) {
                offsets.add(ifdOffset);
            }
        } else {
            while ((long)offsets.size() < totalTiles) {
                offsets.add(0L);
            }
        }
        if (isTiled) {
            ifd.putIFDValue(325, this.toPrimitiveArray(byteCounts));
            ifd.putIFDValue(324, this.toPrimitiveArray(offsets));
        } else {
            ifd.putIFDValue(279, this.toPrimitiveArray(byteCounts));
            ifd.putIFDValue(273, this.toPrimitiveArray(offsets));
        }
        long fp = this.out.offset();
        this.writeIFD(ifd, 0L);
        for (int i = 0; i < strips.length; ++i) {
            this.out.seek(this.out.length());
            int thisOffset = firstOffset + i;
            offsets.set(thisOffset, this.out.offset());
            byteCounts.set(thisOffset, Long.valueOf(strips[i].length));
            if (this.log.isDebug()) {
                this.log.debug((Object)String.format("Writing tile/strip %d/%d size: %d offset: %d", thisOffset + 1, totalTiles, byteCounts.get(thisOffset), offsets.get(thisOffset)));
            }
            this.out.write(strips[i]);
        }
        if (isTiled) {
            ifd.putIFDValue(325, this.toPrimitiveArray(byteCounts));
            ifd.putIFDValue(324, this.toPrimitiveArray(offsets));
        } else {
            ifd.putIFDValue(279, this.toPrimitiveArray(byteCounts));
            ifd.putIFDValue(273, this.toPrimitiveArray(offsets));
        }
        long endFP = this.out.offset();
        if (this.log.isDebug()) {
            this.log.debug((Object)("Offset before IFD write: " + this.out.offset() + " Seeking to: " + fp));
        }
        this.out.seek(fp);
        if (this.log.isDebug()) {
            this.log.debug((Object)("Writing tile/strip offsets: " + Arrays.toString(this.toPrimitiveArray(offsets))));
            this.log.debug((Object)("Writing tile/strip byte counts: " + Arrays.toString(this.toPrimitiveArray(byteCounts))));
        }
        this.writeIFD(ifd, last ? 0L : endFP);
        if (this.log.isDebug()) {
            this.log.debug((Object)("Offset after IFD write: " + this.out.offset()));
        }
    }

    public void writeIFD(IFD ifd, long nextOffset) throws FormatException, IOException {
        TreeSet keys = new TreeSet(ifd.keySet());
        int keyCount = keys.size();
        if (ifd.containsKey(0)) {
            --keyCount;
        }
        if (ifd.containsKey(1)) {
            --keyCount;
        }
        if (ifd.containsKey(3)) {
            --keyCount;
        }
        long fp = this.out.offset();
        int bytesPerEntry = this.bigTiff ? 20 : 12;
        int ifdBytes = (this.bigTiff ? 16 : 6) + bytesPerEntry * keyCount;
        if (this.bigTiff) {
            this.out.writeLong((long)keyCount);
        } else {
            this.out.writeShort(keyCount);
        }
        BytesLocation extra = new BytesLocation(0);
        try (DataHandle extraHandle = (DataHandle)this.dataHandleService.create((Object)extra);){
            for (Integer key : keys) {
                if (key.equals(0) || key.equals(1) || key.equals(3)) continue;
                Object value = ifd.get(key);
                this.writeIFDValue((DataHandle<Location>)extraHandle, (long)ifdBytes + fp, key, value);
            }
            this.writeIntValue(this.out, nextOffset);
            int ifdLen = (int)extraHandle.offset();
            extraHandle.seek(0L);
            DataHandles.copy((DataHandle)extraHandle, this.out, (int)ifdLen);
        }
    }

    public void writeIFDValue(DataHandle<Location> extraOut, long offset, int tag, Object value) throws FormatException, IOException {
        extraOut.setLittleEndian(this.isLittleEndian());
        if (value instanceof Short) {
            value = new short[]{(Short)value};
        } else if (value instanceof Integer) {
            value = new int[]{(Integer)value};
        } else if (value instanceof Long) {
            value = new long[]{(Long)value};
        } else if (value instanceof TiffRational) {
            value = new TiffRational[]{(TiffRational)value};
        } else if (value instanceof Float) {
            value = new float[]{((Float)value).floatValue()};
        } else if (value instanceof Double) {
            value = new double[]{(Double)value};
        }
        int dataLength = this.bigTiff ? 8 : 4;
        this.out.writeShort(tag);
        if (value instanceof short[]) {
            short[] q = (short[])value;
            this.out.writeShort(IFDType.BYTE.getCode());
            this.writeIntValue(this.out, q.length);
            if (q.length <= dataLength) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    this.out.writeByte((int)q[i]);
                }
                for (i = q.length; i < dataLength; ++i) {
                    this.out.writeByte(0);
                }
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeByte((int)q[i]);
                }
            }
        } else if (value instanceof String) {
            char[] q = ((String)value).toCharArray();
            this.out.writeShort(IFDType.ASCII.getCode());
            this.writeIntValue(this.out, q.length + 1);
            if (q.length < dataLength) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    this.out.writeByte((int)q[i]);
                }
                for (i = q.length; i < dataLength; ++i) {
                    this.out.writeByte(0);
                }
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeByte((int)q[i]);
                }
                extraOut.writeByte(0);
            }
        } else if (value instanceof int[]) {
            int[] q = (int[])value;
            this.out.writeShort(IFDType.SHORT.getCode());
            this.writeIntValue(this.out, q.length);
            if (q.length <= dataLength / 2) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    this.out.writeShort(q[i]);
                }
                for (i = q.length; i < dataLength / 2; ++i) {
                    this.out.writeShort(0);
                }
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeShort(q[i]);
                }
            }
        } else if (value instanceof long[]) {
            int div;
            long[] q = (long[])value;
            int type = this.bigTiff ? IFDType.LONG8.getCode() : IFDType.LONG.getCode();
            this.out.writeShort(type);
            this.writeIntValue(this.out, q.length);
            int n = div = this.bigTiff ? 8 : 4;
            if (q.length <= dataLength / div) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    this.writeIntValue(this.out, q[0]);
                }
                for (i = q.length; i < dataLength / div; ++i) {
                    this.writeIntValue(this.out, 0L);
                }
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    this.writeIntValue(extraOut, q[i]);
                }
            }
        } else if (value instanceof TiffRational[]) {
            Object[] q = value;
            this.out.writeShort(IFDType.RATIONAL.getCode());
            this.writeIntValue(this.out, q.length);
            if (this.bigTiff && q.length == 1) {
                this.out.writeInt((int)((TiffRational)q[0]).getNumerator());
                this.out.writeInt((int)((TiffRational)q[0]).getDenominator());
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeInt((int)((TiffRational)q[i]).getNumerator());
                    extraOut.writeInt((int)((TiffRational)q[i]).getDenominator());
                }
            }
        } else if (value instanceof float[]) {
            float[] q = (float[])value;
            this.out.writeShort(IFDType.FLOAT.getCode());
            this.writeIntValue(this.out, q.length);
            if (q.length <= dataLength / 4) {
                int i;
                for (i = 0; i < q.length; ++i) {
                    this.out.writeFloat(q[0]);
                }
                for (i = q.length; i < dataLength / 4; ++i) {
                    this.out.writeInt(0);
                }
            } else {
                this.writeIntValue(this.out, offset + extraOut.length());
                for (int i = 0; i < q.length; ++i) {
                    extraOut.writeFloat(q[i]);
                }
            }
        } else if (value instanceof double[]) {
            double[] q = (double[])value;
            this.out.writeShort(IFDType.DOUBLE.getCode());
            this.writeIntValue(this.out, q.length);
            this.writeIntValue(this.out, offset + extraOut.length());
            for (double doubleVal : q) {
                extraOut.writeDouble(doubleVal);
            }
        } else {
            throw new FormatException("Unknown IFD value type (" + value.getClass().getName() + "): " + value);
        }
    }

    public void overwriteLastIFDOffset(DataHandle<Location> handle) throws FormatException, IOException {
        if (handle == null) {
            throw new FormatException("Output cannot be null");
        }
        TiffParser parser = new TiffParser(this.getContext(), handle);
        parser.getIFDOffsets();
        this.out.seek(handle.offset() - (long)(this.bigTiff ? 8 : 4));
        this.writeIntValue(this.out, 0L);
    }

    public void overwriteIFDValue(DataHandle<Location> raf, int ifd, int tag, Object value) throws FormatException, IOException {
        if (raf == null) {
            throw new FormatException("Output cannot be null");
        }
        this.log.debug((Object)("overwriteIFDValue (ifd=" + ifd + "; tag=" + tag + "; value=" + value + ")"));
        raf.seek(0L);
        TiffParser parser = new TiffParser(this.getContext(), raf);
        Boolean valid = parser.checkHeader();
        if (valid == null) {
            throw new FormatException("Invalid TIFF header");
        }
        boolean little = valid;
        boolean bigTiff = parser.isBigTiff();
        this.setLittleEndian(little);
        this.setBigTiff(bigTiff);
        long offset = bigTiff ? 8L : 4L;
        int bytesPerEntry = bigTiff ? 20 : 12;
        raf.seek(offset);
        long[] offsets = parser.getIFDOffsets();
        if (ifd >= offsets.length) {
            throw new FormatException("No such IFD (" + ifd + " of " + offsets.length + ")");
        }
        raf.seek(offsets[ifd]);
        long num = bigTiff ? raf.readLong() : (long)raf.readUnsignedShort();
        int i = 0;
        while ((long)i < num) {
            raf.seek(offsets[ifd] + (long)(bigTiff ? 8 : 2) + (long)(bytesPerEntry * i));
            TiffIFDEntry entry = parser.readTiffIFDEntry();
            if (entry.getTag() == tag) {
                long newOffset;
                int newCount;
                DataHandle ifdHandle = (DataHandle)this.dataHandleService.create((Object)new BytesLocation(bytesPerEntry));
                DataHandle extraHandle = (DataHandle)this.dataHandleService.create((Object)new BytesLocation(0));
                extraHandle.setLittleEndian(little);
                TiffSaver saver = new TiffSaver((DataHandle<Location>)ifdHandle, new BytesLocation(bytesPerEntry));
                saver.setLittleEndian(this.isLittleEndian());
                saver.writeIFDValue((DataHandle<Location>)extraHandle, entry.getValueOffset(), tag, value);
                ifdHandle.seek(0L);
                extraHandle.seek(0L);
                short newTag = ifdHandle.readShort();
                short newType = ifdHandle.readShort();
                if (bigTiff) {
                    newCount = ifdHandle.readInt();
                    newOffset = ifdHandle.readLong();
                } else {
                    newCount = ifdHandle.readInt();
                    newOffset = ifdHandle.readInt();
                }
                this.log.debug((Object)"overwriteIFDValue:");
                this.log.debug((Object)("\told (" + entry + ");"));
                this.log.debug((Object)("\tnew: (tag=" + newTag + "; type=" + newType + "; count=" + newCount + "; offset=" + newOffset + ")"));
                if (extraHandle.length() == 0L) {
                    this.log.debug((Object)"overwriteIFDValue: new entry is inline");
                } else if (entry.getValueOffset() + (long)(entry.getValueCount() * entry.getType().getBytesPerElement()) == raf.length()) {
                    newOffset = entry.getValueOffset();
                    this.log.debug((Object)"overwriteIFDValue: old entry is at EOF");
                } else if (newCount <= entry.getValueCount()) {
                    newOffset = entry.getValueOffset();
                    this.log.debug((Object)"overwriteIFDValue: new entry is <= old entry");
                } else {
                    newOffset = raf.length();
                    this.log.debug((Object)"overwriteIFDValue: old entry will be orphaned");
                }
                this.out.seek(offsets[ifd] + (long)(bigTiff ? 8 : 2) + (long)(bytesPerEntry * i) + 2L);
                this.out.writeShort((int)newType);
                this.writeIntValue(this.out, newCount);
                this.writeIntValue(this.out, newOffset);
                if (extraHandle.length() > 0L) {
                    this.out.seek(newOffset);
                    extraHandle.seek(0L);
                    DataHandles.copy((DataHandle)extraHandle, this.out, (int)newCount);
                }
                return;
            }
            ++i;
        }
        throw new FormatException("Tag not found (" + IFD.getIFDTagName(tag) + ")");
    }

    public void overwriteComment(DataHandle<Location> in, Object value) throws FormatException, IOException {
        this.overwriteIFDValue(in, 0, 270, value);
    }

    private long[] toPrimitiveArray(List<Long> l) {
        long[] toReturn = new long[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            toReturn[i] = l.get(i);
        }
        return toReturn;
    }

    private void writeIntValue(DataHandle<Location> handle, long offset) throws IOException {
        if (this.bigTiff) {
            handle.writeLong(offset);
        } else {
            handle.writeInt((int)offset);
        }
    }

    private void makeValidIFD(IFD ifd, int pixelType, int nChannels) {
        boolean indexed;
        int bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
        int bps = 8 * bytesPerPixel;
        int[] bpsArray = new int[nChannels];
        Arrays.fill(bpsArray, bps);
        ifd.putIFDValue(258, bpsArray);
        if (FormatTools.isFloatingPoint(pixelType)) {
            ifd.putIFDValue(339, 3);
        }
        if (ifd.getIFDValue(259) == null) {
            ifd.putIFDValue(259, TiffCompression.UNCOMPRESSED.getCode());
        }
        boolean bl = indexed = nChannels == 1 && ifd.getIFDValue(320) != null;
        PhotoInterp pi = indexed ? PhotoInterp.RGB_PALETTE : (nChannels == 1 ? PhotoInterp.BLACK_IS_ZERO : PhotoInterp.RGB);
        ifd.putIFDValue(262, pi.getCode());
        ifd.putIFDValue(277, nChannels);
        if (ifd.get(282) == null) {
            ifd.putIFDValue(282, new TiffRational(1L, 1L));
        }
        if (ifd.get(283) == null) {
            ifd.putIFDValue(283, new TiffRational(1L, 1L));
        }
        if (ifd.get(305) == null) {
            ifd.putIFDValue(305, "SCIFIO");
        }
        if (ifd.get(278) == null) {
            ifd.putIFDValue(278, new long[]{1L});
        }
        if (ifd.get(270) == null) {
            ifd.putIFDValue(270, "");
        }
    }
}

