/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.python.antlr.BaseParser;
import org.python.antlr.NoCloseReaderStream;
import org.python.antlr.ParseException;
import org.python.antlr.PythonPartialLexer;
import org.python.antlr.PythonPartialParser;
import org.python.antlr.PythonTokenSource;
import org.python.antlr.PythonTree;
import org.python.antlr.base.mod;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyIndentationError;
import org.python.core.PySyntaxError;
import org.python.core.io.BufferedReader;
import org.python.core.io.StreamIO;
import org.python.core.io.TextIOInputStream;
import org.python.core.io.UniversalIOWrapper;
import org.python.core.util.StringUtil;

public class ParserFacade {
    private static int MARK_LIMIT = 100000;
    private static final Pattern pep263EncodingPattern = Pattern.compile("#.*coding[:=]\\s*([-\\w.]+)");

    private ParserFacade() {
    }

    private static String getLine(ExpectedEncodingBufferedReader reader, int line) {
        if (reader == null) {
            return "";
        }
        String text2 = null;
        try {
            for (int i = 0; i < line; ++i) {
                text2 = reader.readLine();
            }
            if (text2 == null) {
                return text2;
            }
            if (reader.encoding != null) {
                Charset cs = Charset.forName(reader.encoding);
                ByteBuffer decoded = cs.encode(text2);
                text2 = StringUtil.fromBytes(decoded);
            }
            return text2 + "\n";
        }
        catch (IOException iOException) {
            return text2;
        }
    }

    public static PyException fixParseError(ExpectedEncodingBufferedReader reader, Throwable t, String filename) {
        if (reader != null) {
            try {
                reader.reset();
            }
            catch (IOException e) {
                reader = null;
            }
        }
        if (t instanceof ParseException) {
            ParseException e = (ParseException)t;
            PythonTree node = (PythonTree)e.node;
            int line = e.line;
            int col = e.charPositionInLine;
            if (node != null) {
                line = node.getLineno();
                col = node.getCol_offset();
            }
            String text2 = ParserFacade.getLine(reader, line);
            String msg = e.getMessage();
            if (e.getType() == Py.IndentationError) {
                return new PyIndentationError(msg, line, col, text2, filename);
            }
            PySyntaxError pye = new PySyntaxError(msg, line, col, text2, filename);
            if (e.definite) {
                throw pye;
            }
            return pye;
        }
        if (t instanceof CharacterCodingException) {
            String msg = reader.encoding == null ? "Non-ASCII character in file '" + filename + "', but no encoding declared; see http://www.python.org/peps/pep-0263.html for details" : "Illegal character in file '" + filename + "' for encoding '" + reader.encoding + "'";
            throw Py.SyntaxError(msg);
        }
        return Py.JavaError(t);
    }

    public static mod parseExpressionOrModule(Reader reader, String filename, CompilerFlags cflags) {
        ExpectedEncodingBufferedReader bufReader = null;
        try {
            bufReader = ParserFacade.prepBufReader(reader, cflags, filename);
            return ParserFacade.parse(bufReader, CompileMode.eval, filename, cflags);
        }
        catch (Throwable t) {
            if (bufReader == null) {
                throw Py.JavaError(t);
            }
            try {
                bufReader.reset();
                return ParserFacade.parse(bufReader, CompileMode.exec, filename, cflags);
            }
            catch (Throwable tt) {
                throw ParserFacade.fixParseError(bufReader, tt, filename);
            }
        }
    }

    private static mod parse(ExpectedEncodingBufferedReader reader, CompileMode kind, String filename, CompilerFlags cflags) throws Throwable {
        reader.mark(MARK_LIMIT);
        if (kind != null) {
            NoCloseReaderStream cs = new NoCloseReaderStream(reader);
            BaseParser parser2 = new BaseParser((CharStream)cs, filename, cflags);
            return kind.dispatch(parser2);
        }
        throw Py.ValueError("parse kind must be eval, exec, or single");
    }

    public static mod parse(Reader reader, CompileMode kind, String filename, CompilerFlags cflags) {
        mod mod2;
        ExpectedEncodingBufferedReader bufReader = null;
        try {
            bufReader = ParserFacade.prepBufReader(reader, cflags, filename);
            mod2 = ParserFacade.parse(bufReader, kind, filename, cflags);
        }
        catch (Throwable t) {
            try {
                throw ParserFacade.fixParseError(bufReader, t, filename);
            }
            catch (Throwable throwable) {
                ParserFacade.close(bufReader);
                throw throwable;
            }
        }
        ParserFacade.close(bufReader);
        return mod2;
    }

    public static mod parse(InputStream stream, CompileMode kind, String filename, CompilerFlags cflags) {
        mod mod2;
        ExpectedEncodingBufferedReader bufReader = null;
        try {
            bufReader = ParserFacade.prepBufReader(stream, cflags, filename, false);
            mod2 = ParserFacade.parse(bufReader, kind, filename, cflags);
        }
        catch (Throwable t) {
            try {
                throw ParserFacade.fixParseError(bufReader, t, filename);
            }
            catch (Throwable throwable) {
                ParserFacade.close(bufReader);
                throw throwable;
            }
        }
        ParserFacade.close(bufReader);
        return mod2;
    }

    public static mod parse(String string2, CompileMode kind, String filename, CompilerFlags cflags) {
        mod mod2;
        ExpectedEncodingBufferedReader bufReader = null;
        try {
            bufReader = ParserFacade.prepBufReader(string2, cflags, filename);
            mod2 = ParserFacade.parse(bufReader, kind, filename, cflags);
        }
        catch (Throwable t) {
            try {
                throw ParserFacade.fixParseError(bufReader, t, filename);
            }
            catch (Throwable throwable) {
                ParserFacade.close(bufReader);
                throw throwable;
            }
        }
        ParserFacade.close(bufReader);
        return mod2;
    }

    public static mod partialParse(String string2, CompileMode kind, String filename, CompilerFlags cflags, boolean stdprompt) {
        mod mod2;
        ExpectedEncodingBufferedReader reader = null;
        try {
            reader = ParserFacade.prepBufReader(string2, cflags, filename);
            mod2 = ParserFacade.parse(reader, kind, filename, cflags);
        }
        catch (Throwable t) {
            PyException p;
            block5: {
                mod mod3;
                try {
                    p = ParserFacade.fixParseError(reader, t, filename);
                    if (reader == null || !ParserFacade.validPartialSentence(reader, kind, filename)) break block5;
                    mod3 = null;
                }
                catch (Throwable throwable) {
                    ParserFacade.close(reader);
                    throw throwable;
                }
                ParserFacade.close(reader);
                return mod3;
            }
            throw p;
        }
        ParserFacade.close(reader);
        return mod2;
    }

    private static boolean validPartialSentence(java.io.BufferedReader bufreader, CompileMode kind, String filename) {
        PythonPartialLexer lexer = null;
        try {
            bufreader.reset();
            NoCloseReaderStream cs = new NoCloseReaderStream(bufreader);
            lexer = new PythonPartialLexer((CharStream)cs);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            PythonTokenSource indentedSource = new PythonTokenSource(tokens, filename);
            tokens = new CommonTokenStream((TokenSource)indentedSource);
            PythonPartialParser parser2 = new PythonPartialParser((TokenStream)tokens);
            switch (kind) {
                case single: {
                    parser2.single_input();
                    break;
                }
                case eval: {
                    parser2.eval_input();
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return lexer.eofWhileNested;
        }
        return true;
    }

    private static ExpectedEncodingBufferedReader prepBufReader(Reader reader, CompilerFlags cflags, String filename) throws IOException {
        cflags.source_is_utf8 = true;
        cflags.encoding = "utf-8";
        java.io.BufferedReader bufferedReader = new java.io.BufferedReader(reader);
        bufferedReader.mark(MARK_LIMIT);
        if (ParserFacade.findEncoding(bufferedReader) != null) {
            throw new ParseException("encoding declaration in Unicode string");
        }
        bufferedReader.reset();
        return new ExpectedEncodingBufferedReader((Reader)bufferedReader, null);
    }

    private static ExpectedEncodingBufferedReader prepBufReader(InputStream input, CompilerFlags cflags, String filename, boolean fromString) throws IOException {
        return ParserFacade.prepBufReader(input, cflags, filename, fromString, true);
    }

    private static ExpectedEncodingBufferedReader prepBufReader(InputStream input, CompilerFlags cflags, String filename, boolean fromString, boolean universalNewlines) throws IOException {
        Charset cs;
        input = new BufferedInputStream(input);
        boolean bom = ParserFacade.adjustForBOM(input);
        String encoding = ParserFacade.readEncoding(input);
        if (encoding == null) {
            if (bom) {
                encoding = "utf-8";
            } else if (cflags != null && cflags.encoding != null) {
                encoding = cflags.encoding;
            }
        }
        if (cflags.source_is_utf8) {
            if (encoding != null) {
                throw new ParseException("encoding declaration in Unicode string");
            }
            encoding = "utf-8";
        }
        cflags.encoding = encoding;
        if (universalNewlines) {
            StreamIO rawIO = new StreamIO(input, true);
            BufferedReader bufferedIO = new BufferedReader(rawIO, 0);
            UniversalIOWrapper textIO = new UniversalIOWrapper(bufferedIO);
            input = new TextIOInputStream(textIO);
        }
        try {
            cs = encoding == null ? (fromString ? Charset.forName("ISO-8859-1") : Charset.forName("ascii")) : Charset.forName(encoding);
        }
        catch (UnsupportedCharsetException exc) {
            throw new PySyntaxError("Unknown encoding: " + encoding, 1, 0, "", filename);
        }
        CharsetDecoder dec = cs.newDecoder();
        dec.onMalformedInput(CodingErrorAction.REPORT);
        dec.onUnmappableCharacter(CodingErrorAction.REPORT);
        return new ExpectedEncodingBufferedReader((Reader)new InputStreamReader(input, dec), encoding);
    }

    private static ExpectedEncodingBufferedReader prepBufReader(String string2, CompilerFlags cflags, String filename) throws IOException {
        if (cflags.source_is_utf8) {
            return ParserFacade.prepBufReader(new StringReader(string2), cflags, filename);
        }
        byte[] stringBytes = StringUtil.toBytes(string2);
        return ParserFacade.prepBufReader(new ByteArrayInputStream(stringBytes), cflags, filename, true, false);
    }

    private static boolean adjustForBOM(InputStream stream) throws IOException {
        stream.mark(3);
        int ch = stream.read();
        if (ch == 239) {
            if (stream.read() != 187) {
                throw new ParseException("Incomplete BOM at beginning of file");
            }
            if (stream.read() != 191) {
                throw new ParseException("Incomplete BOM at beginning of file");
            }
            return true;
        }
        stream.reset();
        return false;
    }

    private static String readEncoding(InputStream stream) throws IOException {
        stream.mark(MARK_LIMIT);
        String encoding = null;
        java.io.BufferedReader br = new java.io.BufferedReader(new InputStreamReader(stream, "ISO-8859-1"), 512);
        encoding = ParserFacade.findEncoding(br);
        stream.reset();
        return ParserFacade.encodingMap(encoding);
    }

    private static String findEncoding(java.io.BufferedReader br) throws IOException {
        String strLine;
        String encoding = null;
        for (int i = 0; i < 2 && (strLine = br.readLine()) != null; ++i) {
            String result2 = ParserFacade.matchEncoding(strLine);
            if (result2 == null) continue;
            encoding = result2;
            break;
        }
        return encoding;
    }

    private static String encodingMap(String encoding) {
        if (encoding == null) {
            return null;
        }
        if (encoding.equals("Latin-1") || encoding.equals("latin-1")) {
            return "ISO8859_1";
        }
        return encoding;
    }

    private static String matchEncoding(String inputStr) {
        Matcher matcher = pep263EncodingPattern.matcher(inputStr);
        boolean matchFound = matcher.find();
        if (matchFound && matcher.groupCount() == 1) {
            String groupStr = matcher.group(1);
            return groupStr;
        }
        return null;
    }

    private static void close(java.io.BufferedReader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class ExpectedEncodingBufferedReader
    extends java.io.BufferedReader {
        public final String encoding;

        public ExpectedEncodingBufferedReader(Reader in, String encoding) {
            super(in);
            this.encoding = encoding;
        }
    }
}

