/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.imagej.ops.OpInfo;
import org.scijava.ItemIO;
import org.scijava.module.DefaultMutableModuleItem;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.util.Types;

public class OpListing {
    private final String name;
    private final Class<?> functionalType;
    private final List<Parameter> params;

    public OpListing(OpInfo info) {
        this.name = info.getName();
        this.functionalType = info.getType();
        this.params = new ArrayList<Parameter>();
        info.inputs().forEach(item -> this.params.add(new Parameter((ModuleItem<?>)item)));
        info.outputs().stream().filter(item -> !item.isInput()).forEach(item -> this.params.add(new Parameter((ModuleItem<?>)item)));
    }

    private OpListing(String name, Class<?> functionalType, List<Parameter> params) {
        this.name = name;
        this.functionalType = functionalType;
        this.params = params;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getFunctionalType() {
        return this.functionalType;
    }

    public List<ModuleItem<?>> inputsFor(ModuleInfo info) {
        return this.params.stream().filter(Parameter::isInput).map(param -> param.toModuleItem(info)).collect(Collectors.toList());
    }

    public List<Type> getInputTypes() {
        return this.params.stream().filter(Parameter::isInput).map(p -> ((Parameter)p).type).collect(Collectors.toList());
    }

    public List<String> getInputNames() {
        return this.params.stream().filter(Parameter::isInput).map(p -> ((Parameter)p).name).collect(Collectors.toList());
    }

    public List<ModuleItem<?>> outputsFor(ModuleInfo info) {
        return this.params.stream().filter(Parameter::isOutput).map(p -> p.toModuleItem(info)).collect(Collectors.toList());
    }

    public List<Type> getReturnTypes() {
        return this.params.stream().filter(Parameter::isOutput).map(Parameter::type).collect(Collectors.toList());
    }

    public List<String> getReturnNames() {
        return this.params.stream().filter(Parameter::isOutput).map(Parameter::name).collect(Collectors.toList());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OpListing)) {
            return false;
        }
        OpListing that = (OpListing)obj;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getFunctionalType(), that.getFunctionalType()) && this.params.equals(that.params);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getFunctionalType(), this.params);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        List<Parameter> inputs = this.params.stream().filter(Parameter::isInput).collect(Collectors.toList());
        List<Parameter> outputs = this.params.stream().filter(Parameter::isOutput).collect(Collectors.toList());
        sb.append(this.getName());
        sb.append(this.paramList(inputs));
        if (outputs.size() > 0) {
            sb.append(" -> ").append(this.paramList(outputs));
        }
        return sb.toString();
    }

    public OpListing reduce(Function<Type, Type> typeReducer) {
        List<Parameter> reducedParams = this.params.stream().map(p -> p.reduce(typeReducer)).collect(Collectors.toList());
        return new OpListing(this.name, this.functionalType, reducedParams);
    }

    private String paramList(List<Parameter> params) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Parameter param : params) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(param);
        }
        sb.append(")");
        return sb.toString();
    }

    private static class Parameter {
        private final String name;
        private final Type type;
        private final ItemIO ioType;
        private final boolean isRequired;

        public Parameter(ModuleItem<?> item) {
            this.name = item.getName();
            this.type = item.getGenericType();
            this.ioType = item.getIOType();
            this.isRequired = item.isRequired();
        }

        public Parameter(String name, Type type, ItemIO ioType, boolean isRequired) {
            this.name = name;
            this.type = type;
            this.ioType = ioType;
            this.isRequired = isRequired;
        }

        public String name() {
            return this.name;
        }

        public Type type() {
            return this.type;
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public boolean isInput() {
            return this.ioType == ItemIO.INPUT || this.ioType == ItemIO.BOTH;
        }

        public boolean isOutput() {
            return this.ioType == ItemIO.OUTPUT || this.ioType == ItemIO.BOTH;
        }

        public ModuleItem<?> toModuleItem(ModuleInfo info) {
            DefaultMutableModuleItem item = new DefaultMutableModuleItem(info, this.name, Types.raw((Type)this.type));
            item.setIOType(this.ioType);
            item.setRequired(this.isRequired);
            return item;
        }

        public boolean equals(Object that) {
            if (!(that instanceof Parameter)) {
                return false;
            }
            Parameter thatParam = (Parameter)that;
            return this.name.equals(thatParam.name) && this.type.equals(thatParam.type) && this.ioType.equals((Object)thatParam.ioType) && this.isRequired == thatParam.isRequired;
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.name, this.type, this.ioType, this.isRequired});
        }

        public Parameter reduce(Function<Type, Type> typeReducer) {
            Type reduced = typeReducer.apply(this.type);
            return this.type == reduced ? this : new Parameter(this.name, typeReducer.apply(this.type), this.ioType, this.isRequired);
        }

        public String toString() {
            Class raw = Types.raw((Type)this.type);
            String typeString = this.lowerCamelCase(raw.getSimpleName());
            String optionalString = this.isRequired ? "" : "?";
            return typeString + " \"" + this.name + "\"" + optionalString;
        }

        private String lowerCamelCase(String s) {
            if (s == null || s.isEmpty() || !this.isUpperCase(s.charAt(0))) {
                return s;
            }
            if (s.length() > 1 && this.isUpperCase(s.charAt(1))) {
                int index;
                for (index = 1; index < s.length() && this.isUpperCase(s.charAt(index)); ++index) {
                }
                return s.substring(0, index - 1).toLowerCase() + s.substring(index - 1);
            }
            return s.substring(0, 1).toLowerCase() + s.substring(1);
        }

        private boolean isUpperCase(char c) {
            return c >= 'A' && c <= 'Z';
        }
    }
}

