/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom;

import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.CenterOfGravity.class)
public class DefaultCenterOfGravity<T extends RealType<T>>
extends AbstractUnaryFunctionOp<IterableInterval<T>, RealLocalizable>
implements Ops.Geometric.CenterOfGravity {
    @Override
    public RealLocalizable calculate(IterableInterval<T> input) {
        int i;
        int numDimensions = input.numDimensions();
        double[] output = new double[numDimensions];
        double[] intensityValues = new double[numDimensions];
        Cursor c = input.localizingCursor();
        while (c.hasNext()) {
            c.fwd();
            i = 0;
            while (i < output.length) {
                int n = i;
                output[n] = output[n] + c.getDoublePosition(i) * ((RealType)c.get()).getRealDouble();
                int n2 = i++;
                intensityValues[n2] = intensityValues[n2] + ((RealType)c.get()).getRealDouble();
            }
        }
        for (i = 0; i < output.length; ++i) {
            output[i] = output[i] / intensityValues[i];
        }
        return new RealPoint(output);
    }
}

