/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.topology.eulerCharacteristic;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Topology.EulerCharacteristic26N.class)
public class EulerCharacteristic26N<B extends BooleanType<B>>
extends AbstractUnaryHybridCF<RandomAccessibleInterval<B>, DoubleType>
implements Ops.Topology.EulerCharacteristic26N,
Contingent {
    private static final int[] EULER_LUT = new int[]{0, 1, 1, 0, 1, 0, -2, -1, 1, -2, 0, -1, 0, -1, -1, 0, 1, 0, -2, -1, -2, -1, -1, -2, -6, -3, -3, -2, -3, -2, 0, -1, 1, -2, 0, -1, -6, -3, -3, -2, -2, -1, -1, -2, -3, 0, -2, -1, 0, -1, -1, 0, -3, -2, 0, -1, -3, 0, -2, -1, 0, 1, 1, 0, 1, -2, -6, -3, 0, -1, -3, -2, -2, -1, -3, 0, -1, -2, -2, -1, 0, -1, -3, -2, -1, 0, 0, -1, -3, 0, 0, 1, -2, -1, 1, 0, -2, -1, -3, 0, -3, 0, 0, 1, -1, 4, 0, 3, 0, 3, 1, 2, -1, -2, -2, -1, -2, -1, 1, 0, 0, 3, 1, 2, 1, 2, 2, 1, 1, -6, -2, -3, -2, -3, -1, 0, 0, -3, -1, -2, -1, -2, -2, -1, -2, -3, -1, 0, -1, 0, 4, 3, -3, 0, 0, 1, 0, 1, 3, 2, 0, -3, -1, -2, -3, 0, 0, 1, -1, 0, 0, -1, -2, 1, -1, 0, -1, -2, -2, -1, 0, 1, 3, 2, -2, 1, -1, 0, 1, 2, 2, 1, 0, -3, -3, 0, -1, -2, 0, 1, -1, 0, -2, 1, 0, -1, -1, 0, -1, -2, 0, 1, -2, -1, 3, 2, -2, 1, 1, 2, -1, 0, 2, 1, -1, 0, -2, 1, -2, 1, 1, 2, -2, 3, -1, 2, -1, 2, 0, 1, 0, -1, -1, 0, -1, 0, 2, 1, -1, 2, 0, 1, 0, 1, 1, 0};

    @Override
    public boolean conforms() {
        return ((RandomAccessibleInterval)this.in()).numDimensions() == 3;
    }

    @Override
    public void compute(RandomAccessibleInterval<B> interval, DoubleType output) {
        RandomAccess access = interval.randomAccess();
        long sumDeltaEuler = 0L;
        for (long z = 0L; z < interval.dimension(2) - 1L; ++z) {
            for (long y = 0L; y < interval.dimension(1) - 1L; ++y) {
                for (long x = 0L; x < interval.dimension(0) - 1L; ++x) {
                    int index = EulerCharacteristic26N.neighborhoodEulerIndex(access, x, y, z);
                    sumDeltaEuler += (long)EULER_LUT[index];
                }
            }
        }
        output.set((double)sumDeltaEuler / 8.0);
    }

    @Override
    public DoubleType createOutput(RandomAccessibleInterval<B> input) {
        return new DoubleType(0.0);
    }

    public static <B extends BooleanType<B>> int neighborhoodEulerIndex(RandomAccess<B> access, long x, long y, long z) {
        int index = 0;
        index = (int)((long)index + EulerCharacteristic26N.getAtLocation(access, x, y, z));
        index = (int)((long)index + (EulerCharacteristic26N.getAtLocation(access, x + 1L, y, z) << 1));
        index = (int)((long)index + (EulerCharacteristic26N.getAtLocation(access, x, y + 1L, z) << 2));
        index = (int)((long)index + (EulerCharacteristic26N.getAtLocation(access, x + 1L, y + 1L, z) << 3));
        index = (int)((long)index + (EulerCharacteristic26N.getAtLocation(access, x, y, z + 1L) << 4));
        index = (int)((long)index + (EulerCharacteristic26N.getAtLocation(access, x + 1L, y, z + 1L) << 5));
        index = (int)((long)index + (EulerCharacteristic26N.getAtLocation(access, x, y + 1L, z + 1L) << 6));
        index = (int)((long)index + (EulerCharacteristic26N.getAtLocation(access, x + 1L, y + 1L, z + 1L) << 7));
        return index;
    }

    private static <B extends BooleanType<B>> long getAtLocation(RandomAccess<B> access, long x, long y, long z) {
        access.setPosition(x, 0);
        access.setPosition(y, 1);
        access.setPosition(z, 2);
        return (long)((BooleanType)access.get()).getRealDouble();
    }
}

