/*
 * Decompiled with CFR 0.152.
 */
package client;

import ij.IJ;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

class APIRequestThread
extends Thread {
    boolean stopRequested = false;

    APIRequestThread() {
    }

    public void requestStop() {
        this.stopRequested = true;
    }

    public ArrayList<String[]> doUploadRequest(String apiURL, Hashtable parametersForPost, byte[] data, String cookie_value) {
        ArrayList<Object> result = new ArrayList<String[]>();
        HttpURLConnection connection = null;
        DataOutputStream dos = null;
        String lineEnd = "\r\n";
        String twoHyphens = "--";
        String boundary = "sillymimeboundary";
        int bufferSize = 0x100000;
        try {
            URL url = new URL(apiURL);
            URLConnection urlConnection = url.openConnection();
            if (!(urlConnection instanceof HttpURLConnection)) {
                return null;
            }
            connection = (HttpURLConnection)urlConnection;
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestMethod("POST");
            if (cookie_value != null) {
                System.err.println("sending cookie: " + cookie_value);
                connection.setRequestProperty("Cookie", cookie_value);
            }
            connection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
            dos = new DataOutputStream(connection.getOutputStream());
            System.out.println("Writing data to output (upload) stream...");
            Enumeration e = parametersForPost.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)parametersForPost.get(key);
                System.err.println("" + key + " => " + value);
                dos.writeBytes(twoHyphens + boundary + lineEnd);
                dos.writeBytes("Content-Disposition: form-data; name=\"" + key + "\"" + lineEnd);
                dos.writeBytes(lineEnd);
                dos.writeBytes(value);
                dos.writeBytes(lineEnd);
            }
            if (data != null) {
                dos.writeBytes(twoHyphens + boundary + lineEnd);
                dos.writeBytes("Content-Disposition: form-data; name=\"new-file\"" + lineEnd);
                dos.writeBytes("Content-Type: application/octet-stream" + lineEnd);
                dos.writeBytes("Content-TransferEncoding: binary" + lineEnd);
                dos.writeBytes(lineEnd);
                int bytes_written = 0;
                int bytes_to_write = data.length;
                while (bytes_to_write > 0) {
                    dos.write(data, bytes_written, bytes_to_write);
                    bytes_written = dos.size();
                    bytes_to_write = data.length - bytes_written;
                }
                dos.writeBytes(lineEnd);
            }
            dos.writeBytes(twoHyphens + boundary + twoHyphens + lineEnd);
            dos.flush();
            dos.close();
            System.out.println("Finished writing data to the output (upload) stream.");
        }
        catch (Exception e) {
            System.out.println("Got an exception while uploading the file: " + e);
            e.printStackTrace();
            result = new ArrayList();
            String[] error_array = new String[]{"error", "Got an exception while uploading the file: " + e};
            result.add(error_array);
            return result;
        }
        try {
            String s;
            System.out.println("Reading data from input (download) stream...");
            DataInputStream dis = new DataInputStream(connection.getInputStream());
            do {
                if ((s = dis.readLine()) == null) continue;
                ArrayList<String> tokens = new ArrayList<String>();
                StringTokenizer tokenizer = new StringTokenizer(s, "\t");
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    tokens.add(token);
                }
                String[] tokens_array = new String[tokens.size()];
                for (int i = 0; i < tokens.size(); ++i) {
                    tokens_array[i] = (String)tokens.get(i);
                }
                result.add(tokens_array);
            } while (s != null);
            dis.close();
            System.out.println("Finished reading data from input (download) stream.");
        }
        catch (Exception e) {
            IJ.error((String)("Got an exception while making the request to " + apiURL + ": " + e));
            System.err.println("Got an exception while making the request to " + apiURL + ": " + e);
            e.printStackTrace();
            result = new ArrayList();
            String[] error_array = new String[]{"error", "Got an exception while uploading the file: " + e};
            result.add(error_array);
            return result;
        }
        System.out.println("Upload finished.");
        return result;
    }
}

