/*
 * Decompiled with CFR 0.152.
 */
package events;

import events.SliceEvent;
import events.SliceListener;
import ij.ImageListener;
import ij.ImagePlus;
import java.util.ArrayList;

public class SliceWatcher {
    public static final String MONITOR_LOC = "SliceWatcher.monitor";
    final ImagePlus data;

    public SliceWatcher(ImagePlus data) {
        this.data = data;
        if (data.getProperty(MONITOR_LOC) == null) {
            data.setProperty(MONITOR_LOC, (Object)new SliceMonitor(data));
        }
    }

    private SliceMonitor getMonitor() {
        return (SliceMonitor)this.data.getProperty(MONITOR_LOC);
    }

    public void addSliceListener(SliceListener l) {
        this.getMonitor().addSliceListener(l);
    }

    public boolean removeSliceListener(SliceListener l) {
        return this.getMonitor().removeSliceListener(l);
    }

    private static class SliceMonitor
    implements ImageListener {
        final ImagePlus ip;
        final ArrayList<SliceListener> listeners = new ArrayList();
        int lastSlicenumber;

        public SliceMonitor(ImagePlus ip) {
            this.ip = ip;
            ImagePlus.addImageListener((ImageListener)this);
        }

        public void fireSliceNumberChange(SliceEvent e) {
            for (SliceListener l : this.listeners) {
                try {
                    l.sliceNumberChanged(e);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void addSliceListener(SliceListener l) {
            this.listeners.add(l);
        }

        public boolean removeSliceListener(SliceListener l) {
            return this.listeners.remove(l);
        }

        public void imageOpened(ImagePlus arg0) {
        }

        public void imageClosed(ImagePlus image) {
            if (image == this.ip) {
                image.getProperties().remove(SliceWatcher.MONITOR_LOC);
                this.listeners.clear();
                ImagePlus.removeImageListener((ImageListener)this);
            }
        }

        public void imageUpdated(ImagePlus arg0) {
            int newSlicenumber = this.ip.getCurrentSlice();
            if (newSlicenumber != this.lastSlicenumber) {
                this.fireSliceNumberChange(new SliceEvent(this.ip));
                this.lastSlicenumber = newSlicenumber;
            }
        }
    }
}

