/*
 * Decompiled with CFR 0.152.
 */
package inference;

public class LogFuncs {
    private static final LogFuncs _theInstance = new LogFuncs();
    private static final int maxFactorial = 10000;
    private double[] factorials = new double[10000];
    public static final double pi = Math.PI;
    static final double[] p = new double[]{1.000000000190015, 76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};

    private LogFuncs() {
        this.factorials[0] = 0.0;
        for (int i = 1; i < 10000; ++i) {
            this.factorials[i] = this.factorials[i - 1] + Math.log(i);
        }
    }

    public static double LogFactorial(int n) {
        if (n >= 0 && n < 10000) {
            return LogFuncs._theInstance.factorials[n];
        }
        return LogFuncs.LogGamma(n - 1);
    }

    public static double LogPow(double base, double exponent) {
        return exponent * Math.log(base);
    }

    public static double LogAddLogLog(double loga, double logb) {
        if (loga > logb) {
            return loga + Math.log(1.0 + Math.exp(logb - loga));
        }
        return logb + Math.log(1.0 + Math.exp(loga - logb));
    }

    public static double LogGamma(double z) {
        double sum = p[0];
        for (int i = 1; i < 7; ++i) {
            sum += p[i] / (z + (double)i);
        }
        return 0.5 * Math.log(Math.PI * 2) - Math.log(z) + Math.log(sum) + (z + 0.5) * Math.log(z + 5.5) - (z + 5.5);
    }

    public static double LogPoisson(double lambda, double x) {
        return -lambda + x * Math.log(lambda) - LogFuncs.LogGamma(x + 1.0);
    }
}

