/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.ImagePlus;
import vib.InterpolatedImage;

public class BilateralFilter {
    public static ImagePlus filter(ImagePlus image, double spatialRadius, double rangeRadius) {
        InterpolatedImage orig = new InterpolatedImage(image);
        InterpolatedImage res = orig.cloneDimensionsOnly();
        float[] spatial = BilateralFilter.makeKernel(spatialRadius);
        float[] range = BilateralFilter.makeKernel(rangeRadius);
        res.image.setTitle(orig.image.getTitle() + "-" + spatialRadius + "-" + rangeRadius);
        InterpolatedImage.Iterator iter = res.iterator(true);
        InterpolatedImage o = orig;
        float[] s = spatial;
        int sc = spatial.length / 2;
        float[] r = range;
        int rc = range.length / 2;
        while (iter.next() != null) {
            int v0 = o.getNoInterpol(iter.i, iter.j, iter.k);
            float v = 0.0f;
            float total = 0.0f;
            for (int n = 0; n < s.length; ++n) {
                for (int m = 0; m < s.length; ++m) {
                    int v1 = o.getNoInterpol(iter.i + m - sc, iter.j + n - sc, iter.k);
                    if (Math.abs(v1 - v0) > rc) continue;
                    float w = s[m] * s[n] * r[v1 - v0 + rc];
                    v += (float)v1 * w;
                    total += w;
                }
            }
            res.set(iter.i, iter.j, iter.k, (int)(v / total));
        }
        return res.image;
    }

    public static float[] makeKernel(double radius) {
        float[] kernel;
        block4: {
            int i;
            float total;
            int size;
            block3: {
                size = (int)(radius += 1.0) * 2 - 1;
                kernel = new float[size];
                total = 0.0f;
                for (i = 0; i < size; ++i) {
                    float v;
                    double x = ((double)(i + 1) - radius) / (radius * 2.0) / 0.2;
                    kernel[i] = v = (float)Math.exp(-0.5 * x * x);
                    total += v;
                }
                if (!((double)total <= 0.0)) break block3;
                for (i = 0; i < size; ++i) {
                    kernel[i] = 1.0f / (float)size;
                }
                break block4;
            }
            if ((double)total == 1.0) break block4;
            i = 0;
            while (i < size) {
                int n = i++;
                kernel[n] = kernel[n] / total;
            }
        }
        return kernel;
    }
}

