/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileSaver;
import java.io.File;
import vib.FloatMatrix;
import vib.app.ImageMetaData;
import vib.app.Options;

public class State {
    public Options options;
    public static boolean debug = true;
    private String[][] channels;
    private String imagesPath;
    private String labelPath;
    private String resampledPath;
    private String warpedPath;
    private String outputPath;
    private String statisticsPath;
    private String currentImagePath;
    private ImagePlus currentImage;
    private ImagePlus templateLabels;
    private ImagePlus templ;

    public State(Options options) {
        this.options = options;
        this.imagesPath = this.createDirname("images");
        this.labelPath = this.createDirname("labels");
        this.mkdir(this.labelPath);
        this.resampledPath = options.resamplingFactor > 1 ? this.createDirname("resampled") : null;
        if (options.transformationMethod == 3) {
            this.warpedPath = this.createDirname("warped");
        }
        this.outputPath = this.createDirname("output");
        this.statisticsPath = this.createDirname("statistics");
        this.mkdir(this.statisticsPath);
        for (int c = -1; c < options.numChannels; ++c) {
            if (this.warpedPath != null) {
                this.mkdir(this.warpedPath + this.getChannelName(c));
            }
            if (c >= 0 && options.numChannels > 1) {
                this.mkdir(this.imagesPath + this.getChannelName(c));
            }
            if (this.resampledPath != null) {
                this.mkdir(this.resampledPath + this.getChannelName(c));
            }
            this.mkdir(this.outputPath + this.getChannelName(c));
        }
        int imageCount = options.fileGroup.size();
        this.channels = new String[options.numChannels][imageCount];
        for (int i = 0; i < imageCount; ++i) {
            File file = (File)options.fileGroup.get(i);
            String baseName = file.getName();
            for (int j = 0; j < options.numChannels; ++j) {
                this.channels[j][i] = file.getAbsolutePath();
            }
        }
    }

    public String getBaseName(int index) {
        if (index < 0) {
            return this.getTemplateBaseName();
        }
        return State.getBaseName(this.channels[0][index]);
    }

    public String getTemplateBaseName() {
        return State.getBaseName(this.options.templatePath);
    }

    public static String getBaseName(String fileName) {
        int dot;
        int slash = fileName.lastIndexOf(File.separator);
        if (slash >= 0) {
            fileName = fileName.substring(slash + 1);
        }
        if ((dot = fileName.lastIndexOf(46)) >= 0) {
            fileName = fileName.substring(0, dot);
        }
        return fileName.replace(' ', '_');
    }

    public String getChannelName(int channel) {
        return channel < 0 ? "_labels" : (this.options.numChannels < 2 ? "" : "_" + (channel + 1));
    }

    public String getImagePath(int channel, int index) {
        if (channel < 0) {
            return this.labelPath + File.separator + this.getBaseName(index) + ".labels";
        }
        if (index < 0 && this.options.numChannels == 1) {
            return this.options.templatePath;
        }
        if (this.options.numChannels < 2) {
            return this.channels[channel][index];
        }
        String path = this.imagesPath + this.getChannelName(channel) + File.separator + this.getBaseName(index) + ".tif";
        return path;
    }

    public String getResampledPath(int channel, int index) {
        if (this.options.resamplingFactor == 1) {
            return this.getImagePath(channel, index);
        }
        return this.resampledPath + this.getChannelName(channel) + File.separator + this.getBaseName(index) + ".tif";
    }

    public String getWarpedPath(int channel, int index) {
        if (this.warpedPath == null) {
            return this.getResampledPath(channel, index);
        }
        return this.warpedPath + this.getChannelName(channel) + File.separator + this.getBaseName(index) + ".warped";
    }

    public String getOutputPath(int channel) {
        return this.outputPath + this.getChannelName(channel) + File.separator + this.getTemplateBaseName() + ".tif";
    }

    public String getStatisticsPath() {
        return this.statisticsPath;
    }

    public String getStatisticsPath(int index) {
        return this.statisticsPath + File.separator + this.getBaseName(index) + ".statistics";
    }

    public ImageMetaData getStatistics(int index) {
        try {
            return new ImageMetaData(this.getStatisticsPath(index));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getTransformLabel() {
        return this.getTransformLabel(this.options.transformationMethod);
    }

    public String getTransformLabel(int method) {
        return this.getTemplateBaseName() + Options.TRANSFORM_LABELS[method];
    }

    public FloatMatrix getTransformMatrix(int index) {
        ImageMetaData metaData = this.getStatistics(index);
        FloatMatrix matrix = metaData.getMatrix(this.getTransformLabel());
        return matrix != null ? matrix : new FloatMatrix(1.0f);
    }

    public int getImageCount() {
        return this.channels[0].length;
    }

    public static boolean upToDate(String[] sources, String target) {
        File output = new File(target);
        if (!output.exists()) {
            if (debug) {
                System.err.println("File " + target + " is not up-to-date, since it does not exist");
            }
            return false;
        }
        for (int i = 0; i < sources.length; ++i) {
            File source = new File(sources[i]);
            if (!source.exists()) continue;
            try {
                if (source.lastModified() <= output.lastModified()) continue;
                if (debug) {
                    System.err.println("File " + target + " is older than " + sources[i]);
                }
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static boolean upToDate(String source, String target) {
        return State.upToDate(new String[]{source}, target);
    }

    public boolean save(ImagePlus image, String path) {
        this.currentImagePath = path;
        this.currentImage = image;
        return new FileSaver(image).saveAsTiffStack(path);
    }

    public ImagePlus getImage(String path) {
        if (!path.equals(this.currentImagePath)) {
            File f = new File(path);
            if (!f.exists()) {
                return null;
            }
            this.currentImage = null;
            this.currentImagePath = path;
            this.currentImage = IJ.openImage((String)this.currentImagePath);
        }
        return this.currentImage;
    }

    public ImagePlus getTemplateLabels() {
        if (this.templateLabels == null) {
            this.templateLabels = IJ.openImage((String)this.getResampledPath(-1, -1));
        }
        return this.templateLabels;
    }

    public ImagePlus getTemplate() {
        if (this.templ == null) {
            String path = this.getResampledPath(this.options.refChannel - 1, -1);
            this.templ = IJ.openImage((String)path);
        }
        return this.templ;
    }

    private void mkdir(String path) {
        new File(path).mkdir();
    }

    private String createDirname(String name) {
        return this.options.workingDirectory + File.separator + name;
    }
}

