/*
 * Decompiled with CFR 0.152.
 */
package vib.transforms;

import ij.ImagePlus;
import ij.measure.Calibration;
import math3d.Point3d;
import vib.FastMatrix;
import vib.transforms.Transform;

public class FastMatrixTransform
extends FastMatrix
implements Transform {
    public FastMatrixTransform() {
    }

    public FastMatrixTransform(double f) {
        super(f);
    }

    public FastMatrixTransform(double[][] m) {
        super(m);
    }

    public FastMatrixTransform(FastMatrix f) {
        super(f);
    }

    private FastMatrixTransform invert3x3() {
        double sub00 = this.a11 * this.a22 - this.a12 * this.a21;
        double sub01 = this.a10 * this.a22 - this.a12 * this.a20;
        double sub02 = this.a10 * this.a21 - this.a11 * this.a20;
        double sub10 = this.a01 * this.a22 - this.a02 * this.a21;
        double sub11 = this.a00 * this.a22 - this.a02 * this.a20;
        double sub12 = this.a00 * this.a21 - this.a01 * this.a20;
        double sub20 = this.a01 * this.a12 - this.a02 * this.a11;
        double sub21 = this.a00 * this.a12 - this.a02 * this.a10;
        double sub22 = this.a00 * this.a11 - this.a01 * this.a10;
        double det = this.a00 * sub00 - this.a01 * sub01 + this.a02 * sub02;
        FastMatrixTransform result = new FastMatrixTransform();
        result.a00 = sub00 / det;
        result.a01 = -sub10 / det;
        result.a02 = sub20 / det;
        result.a10 = -sub01 / det;
        result.a11 = sub11 / det;
        result.a12 = -sub21 / det;
        result.a20 = sub02 / det;
        result.a21 = -sub12 / det;
        result.a22 = sub22 / det;
        return result;
    }

    @Override
    public FastMatrixTransform inverse() {
        FastMatrixTransform result = this.invert3x3();
        result.apply(-this.a03, -this.a13, -this.a23);
        result.a03 = result.x;
        result.a13 = result.y;
        result.a23 = result.z;
        return result;
    }

    @Override
    public int getTransformType() {
        return 1;
    }

    @Override
    public Transform composeWith(Transform followedBy) {
        switch (followedBy.getTransformType()) {
            case 0: {
                return null;
            }
            case 1: {
                FastMatrix f = (FastMatrix)((Object)followedBy);
                return this.composeWithFastMatrix(f);
            }
        }
        return null;
    }

    public FastMatrixTransform composeWithFastMatrix(FastMatrix followedBy) {
        FastMatrixTransform A = this;
        FastMatrixTransform B = new FastMatrixTransform(followedBy);
        FastMatrixTransform result = new FastMatrixTransform();
        result.a00 = A.a00 * B.a00 + A.a10 * B.a01 + A.a20 * B.a02;
        result.a10 = A.a00 * B.a10 + A.a10 * B.a11 + A.a20 * B.a12;
        result.a20 = A.a00 * B.a20 + A.a10 * B.a21 + A.a20 * B.a22;
        result.a01 = A.a01 * B.a00 + A.a11 * B.a01 + A.a21 * B.a02;
        result.a11 = A.a01 * B.a10 + A.a11 * B.a11 + A.a21 * B.a12;
        result.a21 = A.a01 * B.a20 + A.a11 * B.a21 + A.a21 * B.a22;
        result.a02 = A.a02 * B.a00 + A.a12 * B.a01 + A.a22 * B.a02;
        result.a12 = A.a02 * B.a10 + A.a12 * B.a11 + A.a22 * B.a12;
        result.a22 = A.a02 * B.a20 + A.a12 * B.a21 + A.a22 * B.a22;
        result.a03 = A.a03 * B.a00 + A.a13 * B.a01 + A.a23 * B.a02 + B.a03;
        result.a13 = A.a03 * B.a10 + A.a13 * B.a11 + A.a23 * B.a12 + B.a13;
        result.a23 = A.a03 * B.a20 + A.a13 * B.a21 + A.a23 * B.a22 + B.a23;
        return result;
    }

    public FastMatrixTransform[] decomposeFully() {
        FastMatrixTransform[] result = new FastMatrixTransform[4];
        FastMatrixTransform copy = new FastMatrixTransform(this);
        result[3] = new FastMatrixTransform(1.0);
        result[3].a03 = this.a03;
        result[3].a13 = this.a13;
        result[3].a23 = this.a23;
        copy.a03 = 0.0;
        copy.a13 = 0.0;
        copy.a23 = 0.0;
        Point3d i = new Point3d(1.0, 0.0, 0.0);
        Point3d j = new Point3d(0.0, 1.0, 0.0);
        Point3d k = new Point3d(0.0, 0.0, 1.0);
        copy.apply(i);
        Point3d i_prime = copy.getResult();
        copy.apply(j);
        Point3d j_prime = copy.getResult();
        copy.apply(k);
        Point3d k_prime = copy.getResult();
        result[2] = new FastMatrixTransform(FastMatrixTransform.rotateToAlignVectors(i_prime.toArray(), j_prime.toArray(), i.toArray(), j.toArray()));
        FastMatrixTransform rotation_inverse = result[2].inverse();
        copy = copy.composeWithFastMatrix(rotation_inverse);
        result[1] = new FastMatrixTransform(i_prime.length());
        FastMatrixTransform scaling_inverse = result[1].inverse();
        result[0] = copy = copy.composeWithFastMatrix(scaling_inverse);
        return result;
    }

    @Override
    public void apply(double x, double y, double z, double[] result) {
        result[0] = x * this.a00 + y * this.a01 + z * this.a02 + this.a03;
        result[1] = x * this.a10 + y * this.a11 + z * this.a12 + this.a13;
        result[2] = x * this.a20 + y * this.a21 + z * this.a22 + this.a23;
    }

    public void setTranslation(double x, double y, double z) {
        this.a03 = x;
        this.a13 = y;
        this.a23 = z;
    }

    public static FastMatrixTransform fromCalibrationWithoutOrigin(ImagePlus image) {
        throw new RuntimeException("BUG: it's very unlikely that you really want to be calling fromCalibrationWithoutOrigin");
    }

    public static FastMatrixTransform fromCalibrationWithoutOrigin(Calibration calib) {
        throw new RuntimeException("BUG: it's very unlikely that you really want to be calling fromCalibrationWithoutOrigin");
    }

    @Override
    public FastMatrixTransform scale(double x, double y, double z) {
        FastMatrixTransform result = new FastMatrixTransform();
        result.a00 = this.a00 * x;
        result.a01 = this.a01 * x;
        result.a02 = this.a02 * x;
        result.a03 = this.a03 * x;
        result.a10 = this.a10 * y;
        result.a11 = this.a11 * y;
        result.a12 = this.a12 * y;
        result.a13 = this.a13 * y;
        result.a20 = this.a20 * z;
        result.a21 = this.a21 * z;
        result.a22 = this.a22 * z;
        result.a23 = this.a23 * z;
        return result;
    }

    public FastMatrixTransform times(FastMatrixTransform o) {
        FastMatrixTransform result = new FastMatrixTransform();
        result.a00 = o.a00 * this.a00 + o.a10 * this.a01 + o.a20 * this.a02;
        result.a10 = o.a00 * this.a10 + o.a10 * this.a11 + o.a20 * this.a12;
        result.a20 = o.a00 * this.a20 + o.a10 * this.a21 + o.a20 * this.a22;
        result.a01 = o.a01 * this.a00 + o.a11 * this.a01 + o.a21 * this.a02;
        result.a11 = o.a01 * this.a10 + o.a11 * this.a11 + o.a21 * this.a12;
        result.a21 = o.a01 * this.a20 + o.a11 * this.a21 + o.a21 * this.a22;
        result.a02 = o.a02 * this.a00 + o.a12 * this.a01 + o.a22 * this.a02;
        result.a12 = o.a02 * this.a10 + o.a12 * this.a11 + o.a22 * this.a12;
        result.a22 = o.a02 * this.a20 + o.a12 * this.a21 + o.a22 * this.a22;
        this.apply(o.a03, o.a13, o.a23);
        result.a03 = this.x;
        result.a13 = this.y;
        result.a23 = this.z;
        return result;
    }

    public FastMatrixTransform plus(FastMatrixTransform other) {
        FastMatrixTransform result = new FastMatrixTransform();
        result.a00 = other.a00 + this.a00;
        result.a01 = other.a01 + this.a01;
        result.a02 = other.a02 + this.a02;
        result.a03 = other.a03 + this.a03;
        result.a10 = other.a10 + this.a10;
        result.a11 = other.a11 + this.a11;
        result.a12 = other.a12 + this.a12;
        result.a13 = other.a13 + this.a13;
        result.a20 = other.a20 + this.a20;
        result.a21 = other.a21 + this.a21;
        result.a22 = other.a22 + this.a22;
        result.a23 = other.a23 + this.a23;
        return result;
    }

    public static FastMatrixTransform translate(double x, double y, double z) {
        FastMatrixTransform result = new FastMatrixTransform();
        result.a22 = 1.0;
        result.a11 = 1.0;
        result.a00 = 1.0;
        result.a03 = x;
        result.a13 = y;
        result.a23 = z;
        return result;
    }
}

