/*
 * Decompiled with CFR 0.152.
 */
package fiji.tool;

import fiji.tool.SliceListener;
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.process.ImageProcessor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class SliceObserver
implements AdjustmentListener,
ImageListener,
WindowListener,
MouseWheelListener {
    protected SliceListener listener;
    protected ImagePlus image;
    protected ImageWindow window;
    protected ImageProcessor ip;
    protected int slice;

    public SliceObserver(ImagePlus image, SliceListener listener) {
        this.image = image;
        this.listener = listener;
        this.register();
    }

    protected boolean notifyIfChanged() {
        int slice;
        ImageProcessor ip;
        boolean changed = false;
        ImageWindow window = this.image.getWindow();
        if (window != this.window) {
            this.window = window;
            changed = true;
        }
        if ((ip = this.image.getProcessor()) != this.ip) {
            this.ip = ip;
            changed = true;
        }
        if ((slice = this.image.getCurrentSlice()) != this.slice) {
            this.slice = slice;
            changed = true;
        }
        if (changed) {
            this.listener.sliceChanged(this.image);
        }
        return changed;
    }

    public static void register(SliceListener listener) {
        int[] ids = WindowManager.getIDList();
        if (ids != null) {
            for (int id : ids) {
                new SliceObserver(WindowManager.getImage((int)id), listener);
            }
        }
    }

    protected void register() {
        ImagePlus.addImageListener((ImageListener)this);
        this.notifyIfChanged();
        if (this.window == null) {
            return;
        }
        this.window.addMouseWheelListener((MouseWheelListener)this);
        for (Component child : this.window.getComponents()) {
            if (child instanceof Scrollbar) {
                ((Scrollbar)child).addAdjustmentListener(this);
                continue;
            }
            if (!(child instanceof Container)) continue;
            for (Component child2 : ((Container)child).getComponents()) {
                if (!(child2 instanceof Scrollbar)) continue;
                ((Scrollbar)child2).addAdjustmentListener(this);
            }
        }
    }

    public ImagePlus getImagePlus() {
        return this.image;
    }

    public void unregister() {
        ImagePlus.removeImageListener((ImageListener)this);
        if (this.window == null) {
            return;
        }
        this.window.removeWindowListener((WindowListener)this);
        this.window.removeMouseWheelListener((MouseWheelListener)this);
        for (Component child : this.window.getComponents()) {
            if (child instanceof Scrollbar) {
                ((Scrollbar)child).removeAdjustmentListener(this);
                continue;
            }
            if (!(child instanceof Container)) continue;
            for (Component child2 : ((Container)child).getComponents()) {
                if (!(child2 instanceof Scrollbar)) continue;
                ((Scrollbar)child2).removeAdjustmentListener(this);
            }
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.notifyIfChanged();
    }

    public void imageOpened(ImagePlus image) {
    }

    public void imageClosed(ImagePlus image) {
        if (image == this.image) {
            this.unregister();
        }
    }

    public void imageUpdated(ImagePlus image) {
        this.notifyIfChanged();
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.notifyIfChanged();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public final void mouseWheelMoved(MouseWheelEvent e) {
        this.notifyIfChanged();
    }

    public static void main(String[] args) {
        SliceObserver.register(new SliceListener(){

            @Override
            public void sliceChanged(ImagePlus image) {
                IJ.log((String)("position in '" + image.getTitle() + "': " + image.getChannel() + ", " + image.getSlice() + ", " + image.getFrame()));
            }
        });
    }
}

