/*
 * Decompiled with CFR 0.152.
 */
package fiji.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public final class NumberParser {
    private NumberParser() {
    }

    public static Number parseNumber(String number, NumberFormat format) {
        try {
            return format.parse(number);
        }
        catch (ParseException exc) {
            NumberFormatException nfe = new NumberFormatException();
            nfe.initCause(exc);
            throw nfe;
        }
    }

    public static Number parseNumber(String number) {
        if (number.matches("-?([0-9]+|[0-9]*\\.[0-9]+)")) {
            return NumberParser.parseNumber(number, NumberFormat.getNumberInstance(Locale.US));
        }
        if ("Infinity".equals(number)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-Infinity".equals(number)) {
            return Double.NEGATIVE_INFINITY;
        }
        if ("NaN".equals(number)) {
            return Double.NaN;
        }
        try {
            return NumberParser.parseNumber(number, NumberFormat.getNumberInstance());
        }
        catch (NumberFormatException exc) {
            return NumberParser.parseNumber(number, NumberFormat.getNumberInstance(Locale.US));
        }
    }

    public static int parseInteger(String number) {
        Number n;
        try {
            n = NumberParser.parseNumber(number, NumberFormat.getIntegerInstance());
        }
        catch (NumberFormatException exc) {
            n = NumberParser.parseNumber(number, NumberFormat.getIntegerInstance(Locale.US));
        }
        return n.intValue();
    }

    public static double parseDouble(String number) {
        return NumberParser.parseNumber(number).doubleValue();
    }
}

