/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.ome;

import java.util.ArrayList;
import java.util.List;
import loci.formats.meta.IPyramidStore;
import loci.formats.ome.OMEXMLMetadataImpl;
import ome.xml.meta.MetadataRoot;
import ome.xml.model.MapPair;
import ome.xml.model.primitives.PositiveInteger;

public class OMEPyramidStore
extends OMEXMLMetadataImpl
implements IPyramidStore {
    public static final String NAMESPACE = "openmicroscopy.org/PyramidResolution";
    private List<List<Resolution>> resolutions = new ArrayList<List<Resolution>>();
    private boolean written = false;

    public String dumpXML() {
        if (!this.written) {
            int annIndex = 0;
            try {
                annIndex = this.getMapAnnotationCount();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            for (int i = 0; i < this.resolutions.size(); ++i) {
                ArrayList<MapPair> resAnnotation = new ArrayList<MapPair>();
                for (int r = 1; r < this.resolutions.get(i).size(); ++r) {
                    resAnnotation.add(new MapPair(String.valueOf(r), this.resolutions.get(i).get(r).toString()));
                }
                String mapId = "Annotation:Resolution:" + i;
                this.setMapAnnotationID(mapId, annIndex);
                this.setMapAnnotationNamespace(NAMESPACE, annIndex);
                this.setMapAnnotationValue(resAnnotation, annIndex);
                ++annIndex;
            }
            this.written = true;
        }
        return super.dumpXML();
    }

    public void setRoot(MetadataRoot root) {
        super.setRoot(root);
        int mapCount = 0;
        try {
            mapCount = this.getMapAnnotationCount();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        for (int i = 0; i < mapCount; ++i) {
            if (!NAMESPACE.equals(this.getMapAnnotationNamespace(i))) continue;
            List resAnnotation = this.getMapAnnotationValue(i);
            ArrayList<Resolution> r = new ArrayList<Resolution>();
            r.add(new Resolution());
            for (MapPair p : resAnnotation) {
                int index = Integer.parseInt(p.getName());
                if (index == r.size()) {
                    r.add(new Resolution(p.getValue()));
                    continue;
                }
                LOGGER.warn("Out of order");
            }
            this.resolutions.add(r);
            this.written = true;
        }
    }

    @Override
    public void setResolutionSizeX(PositiveInteger sizeX, int image, int resolution) {
        this.checkImageIndex(image);
        Resolution r = this.lookupResolution(image, resolution, true);
        r.x = sizeX;
    }

    @Override
    public void setResolutionSizeY(PositiveInteger sizeY, int image, int resolution) {
        this.checkImageIndex(image);
        Resolution r = this.lookupResolution(image, resolution, true);
        r.y = sizeY;
    }

    @Override
    public int getResolutionCount(int image) {
        this.checkImageIndex(image);
        return image < this.resolutions.size() ? this.resolutions.get(image).size() : 1;
    }

    @Override
    public PositiveInteger getResolutionSizeX(int image, int resolution) {
        this.checkResolutionIndex(image, resolution);
        Resolution r = this.lookupResolution(image, resolution);
        return r == null ? null : r.x;
    }

    @Override
    public PositiveInteger getResolutionSizeY(int image, int resolution) {
        this.checkResolutionIndex(image, resolution);
        Resolution r = this.lookupResolution(image, resolution);
        return r == null ? null : r.y;
    }

    private void checkImageIndex(int image) {
        if (image < 0 || image >= this.getImageCount()) {
            throw new IllegalArgumentException("Invalid image index: " + image);
        }
    }

    private void checkResolutionIndex(int image, int res) {
        this.checkImageIndex(image);
        if (res == 0) {
            throw new IllegalArgumentException("Use {get,set}PixelsSize{X,Y} to work with the largest resolution");
        }
        if (res < 0 || res >= this.getResolutionCount(image)) {
            throw new IllegalArgumentException("Invalid resolution index for image #" + image + ": " + res);
        }
    }

    private Resolution lookupResolution(int image, int res) {
        return this.lookupResolution(image, res, false);
    }

    private Resolution lookupResolution(int image, int res, boolean insert) {
        if (image < 0 || image >= this.resolutions.size()) {
            if (insert) {
                this.insertResolution(new Resolution(), image, res);
                return this.lookupResolution(image, res);
            }
            return null;
        }
        List<Resolution> currentResolutions = this.resolutions.get(image);
        if (res < 0 || res >= currentResolutions.size()) {
            if (insert) {
                this.insertResolution(new Resolution(), image, res);
                return this.lookupResolution(image, res);
            }
            return null;
        }
        return currentResolutions.get(res);
    }

    private void insertResolution(Resolution r, int image, int res) {
        while (image >= this.resolutions.size()) {
            this.resolutions.add(new ArrayList());
        }
        List<Resolution> currentResolutions = this.resolutions.get(image);
        while (res > currentResolutions.size()) {
            currentResolutions.add(new Resolution());
        }
        currentResolutions.add(r);
    }

    class Resolution {
        public PositiveInteger x;
        public PositiveInteger y;

        public Resolution() {
        }

        public Resolution(String v) {
            String[] split = v.split(" ");
            this.x = new PositiveInteger(Integer.valueOf(Integer.parseInt(split[0])));
            this.y = new PositiveInteger(Integer.valueOf(Integer.parseInt(split[1])));
        }

        public String toString() {
            return this.x.getValue() + " " + this.y.getValue();
        }
    }
}

