/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.interpolators;

import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.vecmath.Point3f;

public class KBKeyFrame {
    public Point3f position;
    public float heading;
    public float pitch;
    public float bank;
    public Point3f scale;
    public float tension;
    public float continuity;
    public float bias;
    public float knot;
    public int linear;

    KBKeyFrame() {
        this.bias = 0.0f;
        this.continuity = 0.0f;
        this.tension = 0.0f;
    }

    public KBKeyFrame(KBKeyFrame kf) {
        this(kf.knot, kf.linear, kf.position, kf.heading, kf.pitch, kf.bank, kf.scale, kf.tension, kf.continuity, kf.bias);
    }

    public KBKeyFrame(float k, int l, Point3f pos, float hd, float pi, float bk, Point3f s, float t, float c, float b) {
        this.knot = k;
        this.linear = l;
        this.position = new Point3f(pos);
        this.heading = hd;
        this.pitch = pi;
        this.bank = bk;
        this.scale = new Point3f(s);
        if (t < -1.0f || t > 1.0f) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("KBKeyFrame0"));
        }
        if (b < -1.0f || b > 1.0f) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("KBKeyFrame1"));
        }
        if (c < -1.0f || c > 1.0f) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("KBKeyFrame2"));
        }
        this.tension = t;
        this.continuity = c;
        this.bias = b;
    }

    public void debugPrint(String tag) {
        System.out.println("\n" + tag);
        System.out.println(" knot = " + this.knot);
        System.out.println(" linear = " + this.linear);
        System.out.println(" position(x,y,z) = " + this.position.x + " " + this.position.y + " " + this.position.z);
        System.out.println(" tension = " + this.tension);
        System.out.println(" continuity = " + this.continuity);
        System.out.println(" bias = " + this.bias);
    }
}

