/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry.compression;

import org.jogamp.java3d.utils.geometry.compression.CommandStream;
import org.jogamp.java3d.utils.geometry.compression.CompressionStream;
import org.jogamp.java3d.utils.geometry.compression.HuffmanTable;

abstract class CompressionStreamElement {
    int length;
    int shift;
    boolean absolute;
    static final int[] quantizationMask = new int[]{-65536, Short.MIN_VALUE, -16384, -8192, -4096, -2048, -1024, -512, -256, -128, -64, -32, -16, -8, -4, -2, -1};
    static final long[] lengthMask = new long[]{0L, 1L, 3L, 7L, 15L, 31L, 63L, 127L, 255L, 511L, 1023L, 2047L, 4095L, 8191L, 16383L, 32767L, 65535L, 131071L, 262143L, 524287L, 1048575L, 0x1FFFFFL, 0x3FFFFFL, 0x7FFFFFL, 0xFFFFFFL, 0x1FFFFFFL, 0x3FFFFFFL, 0x7FFFFFFL, 0xFFFFFFFL, 0x1FFFFFFFL, 0x3FFFFFFFL, Integer.MAX_VALUE, 0xFFFFFFFFL, 0x1FFFFFFFFL, 0x3FFFFFFFFL, 0x7FFFFFFFFL, 0xFFFFFFFFFL, 0x1FFFFFFFFFL, 0x3FFFFFFFFFL, 0x7FFFFFFFFFL, 0xFFFFFFFFFFL, 0x1FFFFFFFFFFL, 0x3FFFFFFFFFFL, 0x7FFFFFFFFFFL, 0xFFFFFFFFFFFL, 0x1FFFFFFFFFFFL, 0x3FFFFFFFFFFFL, 0x7FFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0x3FFFFFFFFFFFFL, 0x7FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, 0x1FFFFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFFFL, Long.MAX_VALUE, -1L};

    CompressionStreamElement() {
    }

    abstract void quantize(CompressionStream var1, HuffmanTable var2);

    void outputCommand(HuffmanTable table, CommandStream output) {
    }

    private static final int getLength(int number) {
        if (number == 0) {
            return 0;
        }
        if ((number & 0x8000) > 0) {
            if ((number & 0x4000) == 0) {
                return 16;
            }
            if ((number & 0x2000) == 0) {
                return 15;
            }
            if ((number & 0x1000) == 0) {
                return 14;
            }
            if ((number & 0x800) == 0) {
                return 13;
            }
            if ((number & 0x400) == 0) {
                return 12;
            }
            if ((number & 0x200) == 0) {
                return 11;
            }
            if ((number & 0x100) == 0) {
                return 10;
            }
            if ((number & 0x80) == 0) {
                return 9;
            }
            if ((number & 0x40) == 0) {
                return 8;
            }
            if ((number & 0x20) == 0) {
                return 7;
            }
            if ((number & 0x10) == 0) {
                return 6;
            }
            if ((number & 8) == 0) {
                return 5;
            }
            if ((number & 4) == 0) {
                return 4;
            }
            if ((number & 2) == 0) {
                return 3;
            }
            if ((number & 1) == 0) {
                return 2;
            }
            return 1;
        }
        if ((number & 0x4000) > 0) {
            return 16;
        }
        if ((number & 0x2000) > 0) {
            return 15;
        }
        if ((number & 0x1000) > 0) {
            return 14;
        }
        if ((number & 0x800) > 0) {
            return 13;
        }
        if ((number & 0x400) > 0) {
            return 12;
        }
        if ((number & 0x200) > 0) {
            return 11;
        }
        if ((number & 0x100) > 0) {
            return 10;
        }
        if ((number & 0x80) > 0) {
            return 9;
        }
        if ((number & 0x40) > 0) {
            return 8;
        }
        if ((number & 0x20) > 0) {
            return 7;
        }
        if ((number & 0x10) > 0) {
            return 6;
        }
        if ((number & 8) > 0) {
            return 5;
        }
        if ((number & 4) > 0) {
            return 4;
        }
        if ((number & 2) > 0) {
            return 3;
        }
        return 2;
    }

    private static final int getShift(int number) {
        if (number == 0) {
            return 0;
        }
        if ((number & 1) > 0) {
            return 0;
        }
        if ((number & 2) > 0) {
            return 1;
        }
        if ((number & 4) > 0) {
            return 2;
        }
        if ((number & 8) > 0) {
            return 3;
        }
        if ((number & 0x10) > 0) {
            return 4;
        }
        if ((number & 0x20) > 0) {
            return 5;
        }
        if ((number & 0x40) > 0) {
            return 6;
        }
        if ((number & 0x80) > 0) {
            return 7;
        }
        if ((number & 0x100) > 0) {
            return 8;
        }
        if ((number & 0x200) > 0) {
            return 9;
        }
        if ((number & 0x400) > 0) {
            return 10;
        }
        if ((number & 0x800) > 0) {
            return 11;
        }
        if ((number & 0x1000) > 0) {
            return 12;
        }
        if ((number & 0x2000) > 0) {
            return 13;
        }
        if ((number & 0x4000) > 0) {
            return 14;
        }
        return 15;
    }

    final void computeLengthShift(int n0, int n1) {
        int s0 = n0 & 0x8000;
        int s1 = n1 & 0x8000;
        this.length = s0 == s1 ? (s0 == 0 ? CompressionStreamElement.getLength(n0 | n1) : CompressionStreamElement.getLength(n0 & n1)) : CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n0), CompressionStreamElement.getLength(n1));
        this.shift = CompressionStreamElement.getShift(n0 | n1);
    }

    final void computeLengthShift(int n0, int n1, int n2) {
        int s0 = n0 & 0x8000;
        int s1 = n1 & 0x8000;
        int s2 = n2 & 0x8000;
        this.length = s0 == s1 ? (s1 == s2 ? (s2 == 0 ? CompressionStreamElement.getLength(n0 | n1 | n2) : CompressionStreamElement.getLength(n0 & n1 & n2)) : (s1 == 0 ? CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n0 | n1), CompressionStreamElement.getLength(n2)) : CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n0 & n1), CompressionStreamElement.getLength(n2)))) : (s1 == s2 ? (s2 == 0 ? CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n1 | n2), CompressionStreamElement.getLength(n0)) : CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n1 & n2), CompressionStreamElement.getLength(n0))) : (s0 == 0 ? CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n0 | n2), CompressionStreamElement.getLength(n1)) : CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n0 & n2), CompressionStreamElement.getLength(n1))));
        this.shift = CompressionStreamElement.getShift(n0 | n1 | n2);
    }

    final void computeLengthShift(int n0, int n1, int n2, int n3) {
        this.length = CompressionStreamElement.getMaximum(CompressionStreamElement.getLength(n0), CompressionStreamElement.getLength(n1), CompressionStreamElement.getLength(n2), CompressionStreamElement.getLength(n3));
        this.shift = CompressionStreamElement.getShift(n0 | n1 | n2 | n3);
    }

    private static final int getMaximum(int x, int y) {
        if (x > y) {
            return x;
        }
        return y;
    }

    private static final int getMaximum(int x, int y, int z) {
        if (x > y) {
            if (x > z) {
                return x;
            }
            return z;
        }
        if (y > z) {
            return y;
        }
        return z;
    }

    private static final int getMaximum(int x, int y, int z, int w) {
        int n1;
        int n0 = x > y ? x : y;
        if (n0 > (n1 = z > w ? z : w)) {
            return n0;
        }
        return n1;
    }
}

