/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.universe;

import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.utils.universe.ConfigCommand;
import org.jogamp.java3d.utils.universe.ConfigObject;
import org.jogamp.vecmath.Matrix4d;
import org.jogamp.vecmath.Point2d;

class ConfigScreen
extends ConfigObject {
    int frameBufferNumber;
    double physicalScreenWidth = 0.0;
    double physicalScreenHeight = 0.0;
    Matrix4d trackerBaseToImagePlate = null;
    Matrix4d headTrackerToLeftImagePlate = null;
    Matrix4d headTrackerToRightImagePlate = null;
    int monoscopicViewPolicy = 2;
    boolean fullScreen = false;
    boolean noBorderFullScreen = false;
    int windowWidthInPixels = 512;
    int windowHeightInPixels = 512;
    int windowX = 0;
    int windowY = 0;
    JFrame j3dJFrame;
    Window j3dWindow;
    JPanel j3dJPanel;
    Canvas3D j3dCanvas;

    ConfigScreen() {
    }

    @Override
    protected void setProperty(ConfigCommand command) {
        String attr = null;
        Object val = null;
        String sval = null;
        if (command.argc != 4) {
            this.syntaxError("Incorrect number of arguments to " + command.commandName);
        }
        if (!this.isName(command.argv[2])) {
            this.syntaxError("The second argument to " + command.commandName + " must be a property name");
        }
        attr = (String)command.argv[2];
        val = command.argv[3];
        if (attr.equals("PhysicalScreenWidth")) {
            if (!(val instanceof Double)) {
                this.syntaxError("Value for PhysicalScreenWidth must be a number");
            }
            this.physicalScreenWidth = (Double)val;
        } else if (attr.equals("PhysicalScreenHeight")) {
            if (!(val instanceof Double)) {
                this.syntaxError("Value for PhysicalScreenHeight must be a number");
            }
            this.physicalScreenHeight = (Double)val;
        } else if (attr.equals("TrackerBaseToImagePlate")) {
            if (!(val instanceof Matrix4d)) {
                this.syntaxError("Value for TrackerBaseToImagePlate must be a 4x3 or 4x4 matrix");
            }
            this.trackerBaseToImagePlate = (Matrix4d)val;
        } else if (attr.equals("HeadTrackerToLeftImagePlate")) {
            if (!(val instanceof Matrix4d)) {
                this.syntaxError("Value for HeadTrackerToLeftImagePlate must be a 4x3 or 4x4 matrix");
            }
            this.headTrackerToLeftImagePlate = (Matrix4d)val;
        } else if (attr.equals("HeadTrackerToRightImagePlate")) {
            if (!(val instanceof Matrix4d)) {
                this.syntaxError("Value for HeadTrackerToRightImagePlate must be a 4x3 or 4x4 matrix");
            }
            this.headTrackerToRightImagePlate = (Matrix4d)val;
        } else if (attr.equals("MonoscopicViewPolicy")) {
            if (!(val instanceof String)) {
                this.syntaxError("Value for MonoscopicViewPolicy must be a name");
            }
            if ((sval = (String)val).equals("LEFT_EYE_VIEW")) {
                this.monoscopicViewPolicy = 0;
            } else if (sval.equals("RIGHT_EYE_VIEW")) {
                this.monoscopicViewPolicy = 1;
            } else if (sval.equals("CYCLOPEAN_EYE_VIEW")) {
                this.monoscopicViewPolicy = 2;
            } else {
                this.syntaxError("Invalid value for MonoscopicViewPolicy \"" + sval + "\"");
            }
        } else if (attr.equals("WindowPosition")) {
            if (!(val instanceof Point2d)) {
                this.syntaxError("WindowPosition must be a Point2d");
            }
            Point2d p2d = (Point2d)val;
            this.windowX = (int)p2d.x;
            this.windowY = (int)p2d.y;
        } else if (attr.equals("WindowSize")) {
            if (val instanceof Point2d) {
                this.fullScreen = false;
                this.noBorderFullScreen = false;
                Point2d p2d = (Point2d)val;
                this.windowWidthInPixels = (int)p2d.x;
                this.windowHeightInPixels = (int)p2d.y;
            } else if (val instanceof String) {
                String s = (String)val;
                if (s.equals("FullScreen")) {
                    this.fullScreen = true;
                    this.noBorderFullScreen = false;
                } else if (s.equals("NoBorderFullScreen")) {
                    this.fullScreen = false;
                    this.noBorderFullScreen = true;
                } else {
                    this.syntaxError("Value for WindowSize must be one of\n\"FullScreen\" \"NoBorderFullScreen\" or Point2d");
                }
            } else {
                this.syntaxError("Invalid WindowSize value: " + val + "\nValue for WindowSize " + "must be one of\n" + "\"FullScreen\" " + "\"NoBorderFullScreen\" or Point2d");
            }
        } else {
            this.syntaxError("Unknown " + command.commandName + " \"" + attr + "\"");
        }
    }

    @Override
    protected void initialize(ConfigCommand command) {
        if (command.argc != 3) {
            this.syntaxError("Incorrect number of arguments to " + command.commandName);
        }
        if (!(command.argv[2] instanceof Double)) {
            this.syntaxError("The second argument to " + command.commandName + " must be a GraphicsDevice index");
        }
        this.frameBufferNumber = ((Double)command.argv[2]).intValue();
    }
}

